package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Used by a remote client to define how it connects to a server.
 */
@ResourceType("remote-connector")
public class RemoteConnector<T extends RemoteConnector> {

	private String key;
	private Map params = new java.util.HashMap<String, Object>();
	private String socketBinding;

	public RemoteConnector(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to configure it.
	 */
	@SuppressWarnings("unchecked")
	public RemoteConnector params(Map value) {
		this.params = value;
		return (RemoteConnector) this;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to configure it.
	 */
	public RemoteConnector paramsEntry(String key, Object value) {
		this.params.put(key, value);
		return (RemoteConnector) this;
	}

	/**
	 * The socket binding that the connector will use to create connections.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The socket binding that the connector will use to create connections.
	 */
	@SuppressWarnings("unchecked")
	public RemoteConnector socketBinding(String value) {
		this.socketBinding = value;
		return (RemoteConnector) this;
	}
}