package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@ResourceType("ha-policy")
@Implicit
public class ReplicationSlaveHAPolicy<T extends ReplicationSlaveHAPolicy> {

	private String key;
	private Boolean allowFailback;
	private String clusterName;
	private Long failbackDelay;
	private String groupName;
	private Integer maxSavedReplicatedJournalSize;
	private Boolean restartBackup;
	private Boolean scaleDown;
	private String scaleDownClusterName;
	private List<String> scaleDownConnectors = new java.util.ArrayList<>();
	private String scaleDownDiscoveryGroup;
	private String scaleDownGroupName;

	public ReplicationSlaveHAPolicy() {
		this.key = "replication-slave";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether a server will automatically stop when a another places a request to take over its place. The use case is when a regular server stops and its backup takes over its duties, later the main server restarts and requests the server (the former backup) to stop operating.
	 */
	@ModelNodeBinding(detypedName = "allow-failback")
	public Boolean allowFailback() {
		return this.allowFailback;
	}

	/**
	 * Whether a server will automatically stop when a another places a request to take over its place. The use case is when a regular server stops and its backup takes over its duties, later the main server restarts and requests the server (the former backup) to stop operating.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationSlaveHAPolicy allowFailback(Boolean value) {
		this.allowFailback = value;
		return (ReplicationSlaveHAPolicy) this;
	}

	/**
	 * Name of the cluster used for replication.
	 */
	@ModelNodeBinding(detypedName = "cluster-name")
	public String clusterName() {
		return this.clusterName;
	}

	/**
	 * Name of the cluster used for replication.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationSlaveHAPolicy clusterName(String value) {
		this.clusterName = value;
		return (ReplicationSlaveHAPolicy) this;
	}

	/**
	 * delay to wait before failback occurs on (live's) restart
	 */
	@ModelNodeBinding(detypedName = "failback-delay")
	public Long failbackDelay() {
		return this.failbackDelay;
	}

	/**
	 * delay to wait before failback occurs on (live's) restart
	 */
	@SuppressWarnings("unchecked")
	public ReplicationSlaveHAPolicy failbackDelay(Long value) {
		this.failbackDelay = value;
		return (ReplicationSlaveHAPolicy) this;
	}

	/**
	 * If set, backup servers will only pair with live servers with matching group-name.
	 */
	@ModelNodeBinding(detypedName = "group-name")
	public String groupName() {
		return this.groupName;
	}

	/**
	 * If set, backup servers will only pair with live servers with matching group-name.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationSlaveHAPolicy groupName(String value) {
		this.groupName = value;
		return (ReplicationSlaveHAPolicy) this;
	}

	/**
	 * This specifies how many times a replicated backup server can restart after moving its files on start. Once there are this number of backup journal files the server will stop permanently after if fails back.
	 */
	@ModelNodeBinding(detypedName = "max-saved-replicated-journal-size")
	public Integer maxSavedReplicatedJournalSize() {
		return this.maxSavedReplicatedJournalSize;
	}

	/**
	 * This specifies how many times a replicated backup server can restart after moving its files on start. Once there are this number of backup journal files the server will stop permanently after if fails back.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationSlaveHAPolicy maxSavedReplicatedJournalSize(Integer value) {
		this.maxSavedReplicatedJournalSize = value;
		return (ReplicationSlaveHAPolicy) this;
	}

	/**
	 * Will this server, if a backup, restart once it has been stopped because of failback or scaling down.
	 */
	@ModelNodeBinding(detypedName = "restart-backup")
	public Boolean restartBackup() {
		return this.restartBackup;
	}

	/**
	 * Will this server, if a backup, restart once it has been stopped because of failback or scaling down.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationSlaveHAPolicy restartBackup(Boolean value) {
		this.restartBackup = value;
		return (ReplicationSlaveHAPolicy) this;
	}

	/**
	 * Configure whether this server send its messages to another live server in the scale-down cluster when it is shutdown cleanly.
	 */
	@ModelNodeBinding(detypedName = "scale-down")
	public Boolean scaleDown() {
		return this.scaleDown;
	}

	/**
	 * Configure whether this server send its messages to another live server in the scale-down cluster when it is shutdown cleanly.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationSlaveHAPolicy scaleDown(Boolean value) {
		this.scaleDown = value;
		return (ReplicationSlaveHAPolicy) this;
	}

	/**
	 * Name of the cluster used to scale down.
	 */
	@ModelNodeBinding(detypedName = "scale-down-cluster-name")
	public String scaleDownClusterName() {
		return this.scaleDownClusterName;
	}

	/**
	 * Name of the cluster used to scale down.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationSlaveHAPolicy scaleDownClusterName(String value) {
		this.scaleDownClusterName = value;
		return (ReplicationSlaveHAPolicy) this;
	}

	/**
	 * List of connectors used to form the scale-down cluster.
	 */
	@ModelNodeBinding(detypedName = "scale-down-connectors")
	public List<String> scaleDownConnectors() {
		return this.scaleDownConnectors;
	}

	/**
	 * List of connectors used to form the scale-down cluster.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationSlaveHAPolicy scaleDownConnectors(List<String> value) {
		this.scaleDownConnectors = value;
		return (ReplicationSlaveHAPolicy) this;
	}

	/**
	 * List of connectors used to form the scale-down cluster.
	 */
	public ReplicationSlaveHAPolicy scaleDownConnectorsValue(String value) {
		this.scaleDownConnectors.add(value);
		return (ReplicationSlaveHAPolicy) this;
	}

	/**
	 * Name of the discovery group used to build the scale-down cluster
	 */
	@ModelNodeBinding(detypedName = "scale-down-discovery-group")
	public String scaleDownDiscoveryGroup() {
		return this.scaleDownDiscoveryGroup;
	}

	/**
	 * Name of the discovery group used to build the scale-down cluster
	 */
	@SuppressWarnings("unchecked")
	public ReplicationSlaveHAPolicy scaleDownDiscoveryGroup(String value) {
		this.scaleDownDiscoveryGroup = value;
		return (ReplicationSlaveHAPolicy) this;
	}

	/**
	 * Name of the group used to scale down.
	 */
	@ModelNodeBinding(detypedName = "scale-down-group-name")
	public String scaleDownGroupName() {
		return this.scaleDownGroupName;
	}

	/**
	 * Name of the group used to scale down.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationSlaveHAPolicy scaleDownGroupName(String value) {
		this.scaleDownGroupName = value;
		return (ReplicationSlaveHAPolicy) this;
	}
}