package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A Queue.
 */
@ResourceType("runtime-queue")
public class RuntimeQueue<T extends RuntimeQueue> {

	private String key;
	private Integer consumerCount;
	private String deadLetterAddress;
	private Integer deliveringCount;
	private Boolean durable;
	private String expiryAddress;
	private String filter;
	private Long id;
	private Long messageCount;
	private Long messagesAdded;
	private Boolean paused;
	private String queueAddress;
	private Long scheduledCount;
	private Boolean temporary;

	public RuntimeQueue(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@ModelNodeBinding(detypedName = "consumer-count")
	public Integer consumerCount() {
		return this.consumerCount;
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue consumerCount(Integer value) {
		this.consumerCount = value;
		return (RuntimeQueue) this;
	}

	/**
	 * The address to send the queue's dead messages to.
	 */
	@ModelNodeBinding(detypedName = "dead-letter-address")
	public String deadLetterAddress() {
		return this.deadLetterAddress;
	}

	/**
	 * The address to send the queue's dead messages to.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue deadLetterAddress(String value) {
		this.deadLetterAddress = value;
		return (RuntimeQueue) this;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@ModelNodeBinding(detypedName = "delivering-count")
	public Integer deliveringCount() {
		return this.deliveringCount;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue deliveringCount(Integer value) {
		this.deliveringCount = value;
		return (RuntimeQueue) this;
	}

	/**
	 * Defines whether the queue is durable.
	 */
	@ModelNodeBinding(detypedName = "durable")
	public Boolean durable() {
		return this.durable;
	}

	/**
	 * Defines whether the queue is durable.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue durable(Boolean value) {
		this.durable = value;
		return (RuntimeQueue) this;
	}

	/**
	 * The address to send the queue's expired messages to.
	 */
	@ModelNodeBinding(detypedName = "expiry-address")
	public String expiryAddress() {
		return this.expiryAddress;
	}

	/**
	 * The address to send the queue's expired messages to.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue expiryAddress(String value) {
		this.expiryAddress = value;
		return (RuntimeQueue) this;
	}

	/**
	 * A queue message filter definition. An undefined or empty filter will match all messages.
	 */
	@ModelNodeBinding(detypedName = "filter")
	public String filter() {
		return this.filter;
	}

	/**
	 * A queue message filter definition. An undefined or empty filter will match all messages.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue filter(String value) {
		this.filter = value;
		return (RuntimeQueue) this;
	}

	/**
	 * The id of the queue.
	 */
	@ModelNodeBinding(detypedName = "id")
	public Long id() {
		return this.id;
	}

	/**
	 * The id of the queue.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue id(Long value) {
		this.id = value;
		return (RuntimeQueue) this;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@ModelNodeBinding(detypedName = "message-count")
	public Long messageCount() {
		return this.messageCount;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue messageCount(Long value) {
		this.messageCount = value;
		return (RuntimeQueue) this;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@ModelNodeBinding(detypedName = "messages-added")
	public Long messagesAdded() {
		return this.messagesAdded;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue messagesAdded(Long value) {
		this.messagesAdded = value;
		return (RuntimeQueue) this;
	}

	/**
	 * Whether the queue is paused.
	 */
	@ModelNodeBinding(detypedName = "paused")
	public Boolean paused() {
		return this.paused;
	}

	/**
	 * Whether the queue is paused.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue paused(Boolean value) {
		this.paused = value;
		return (RuntimeQueue) this;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@ModelNodeBinding(detypedName = "queue-address")
	public String queueAddress() {
		return this.queueAddress;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue queueAddress(String value) {
		this.queueAddress = value;
		return (RuntimeQueue) this;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@ModelNodeBinding(detypedName = "scheduled-count")
	public Long scheduledCount() {
		return this.scheduledCount;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue scheduledCount(Long value) {
		this.scheduledCount = value;
		return (RuntimeQueue) this;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@ModelNodeBinding(detypedName = "temporary")
	public Boolean temporary() {
		return this.temporary;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@SuppressWarnings("unchecked")
	public RuntimeQueue temporary(Boolean value) {
		this.temporary = value;
		return (RuntimeQueue) this;
	}
}