package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@ResourceType("ha-policy")
@Implicit
public class SharedStoreMasterHAPolicy<T extends SharedStoreMasterHAPolicy> {

	private String key;
	private Long failbackDelay;
	private Boolean failoverOnServerShutdown;

	public SharedStoreMasterHAPolicy() {
		this.key = "shared-store-master";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * delay to wait before failback occurs on (live's) restart
	 */
	@ModelNodeBinding(detypedName = "failback-delay")
	public Long failbackDelay() {
		return this.failbackDelay;
	}

	/**
	 * delay to wait before failback occurs on (live's) restart
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreMasterHAPolicy failbackDelay(Long value) {
		this.failbackDelay = value;
		return (SharedStoreMasterHAPolicy) this;
	}

	/**
	 * Whether the server must failover when it is normally shutdown.
	 */
	@ModelNodeBinding(detypedName = "failover-on-server-shutdown")
	public Boolean failoverOnServerShutdown() {
		return this.failoverOnServerShutdown;
	}

	/**
	 * Whether the server must failover when it is normally shutdown.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreMasterHAPolicy failoverOnServerShutdown(Boolean value) {
		this.failoverOnServerShutdown = value;
		return (SharedStoreMasterHAPolicy) this;
	}
}