package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@ResourceType("ha-policy")
@Implicit
public class SharedStoreSlaveHAPolicy<T extends SharedStoreSlaveHAPolicy> {

	private String key;
	private Boolean allowFailback;
	private Long failbackDelay;
	private Boolean failoverOnServerShutdown;
	private Boolean restartBackup;
	private Boolean scaleDown;
	private String scaleDownClusterName;
	private List<String> scaleDownConnectors = new java.util.ArrayList<>();
	private String scaleDownDiscoveryGroup;
	private String scaleDownGroupName;

	public SharedStoreSlaveHAPolicy() {
		this.key = "shared-store-slave";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether a server will automatically stop when a another places a request to take over its place. The use case is when a regular server stops and its backup takes over its duties, later the main server restarts and requests the server (the former backup) to stop operating.
	 */
	@ModelNodeBinding(detypedName = "allow-failback")
	public Boolean allowFailback() {
		return this.allowFailback;
	}

	/**
	 * Whether a server will automatically stop when a another places a request to take over its place. The use case is when a regular server stops and its backup takes over its duties, later the main server restarts and requests the server (the former backup) to stop operating.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreSlaveHAPolicy allowFailback(Boolean value) {
		this.allowFailback = value;
		return (SharedStoreSlaveHAPolicy) this;
	}

	/**
	 * delay to wait before failback occurs on (live's) restart
	 */
	@ModelNodeBinding(detypedName = "failback-delay")
	public Long failbackDelay() {
		return this.failbackDelay;
	}

	/**
	 * delay to wait before failback occurs on (live's) restart
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreSlaveHAPolicy failbackDelay(Long value) {
		this.failbackDelay = value;
		return (SharedStoreSlaveHAPolicy) this;
	}

	/**
	 * Whether the server must failover when it is normally shutdown.
	 */
	@ModelNodeBinding(detypedName = "failover-on-server-shutdown")
	public Boolean failoverOnServerShutdown() {
		return this.failoverOnServerShutdown;
	}

	/**
	 * Whether the server must failover when it is normally shutdown.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreSlaveHAPolicy failoverOnServerShutdown(Boolean value) {
		this.failoverOnServerShutdown = value;
		return (SharedStoreSlaveHAPolicy) this;
	}

	/**
	 * Will this server, if a backup, restart once it has been stopped because of failback or scaling down.
	 */
	@ModelNodeBinding(detypedName = "restart-backup")
	public Boolean restartBackup() {
		return this.restartBackup;
	}

	/**
	 * Will this server, if a backup, restart once it has been stopped because of failback or scaling down.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreSlaveHAPolicy restartBackup(Boolean value) {
		this.restartBackup = value;
		return (SharedStoreSlaveHAPolicy) this;
	}

	/**
	 * Configure whether this server send its messages to another live server in the scale-down cluster when it is shutdown cleanly.
	 */
	@ModelNodeBinding(detypedName = "scale-down")
	public Boolean scaleDown() {
		return this.scaleDown;
	}

	/**
	 * Configure whether this server send its messages to another live server in the scale-down cluster when it is shutdown cleanly.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreSlaveHAPolicy scaleDown(Boolean value) {
		this.scaleDown = value;
		return (SharedStoreSlaveHAPolicy) this;
	}

	/**
	 * Name of the cluster used to scale down.
	 */
	@ModelNodeBinding(detypedName = "scale-down-cluster-name")
	public String scaleDownClusterName() {
		return this.scaleDownClusterName;
	}

	/**
	 * Name of the cluster used to scale down.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreSlaveHAPolicy scaleDownClusterName(String value) {
		this.scaleDownClusterName = value;
		return (SharedStoreSlaveHAPolicy) this;
	}

	/**
	 * List of connectors used to form the scale-down cluster.
	 */
	@ModelNodeBinding(detypedName = "scale-down-connectors")
	public List<String> scaleDownConnectors() {
		return this.scaleDownConnectors;
	}

	/**
	 * List of connectors used to form the scale-down cluster.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreSlaveHAPolicy scaleDownConnectors(List<String> value) {
		this.scaleDownConnectors = value;
		return (SharedStoreSlaveHAPolicy) this;
	}

	/**
	 * List of connectors used to form the scale-down cluster.
	 */
	public SharedStoreSlaveHAPolicy scaleDownConnectorsValue(String value) {
		this.scaleDownConnectors.add(value);
		return (SharedStoreSlaveHAPolicy) this;
	}

	/**
	 * Name of the discovery group used to build the scale-down cluster
	 */
	@ModelNodeBinding(detypedName = "scale-down-discovery-group")
	public String scaleDownDiscoveryGroup() {
		return this.scaleDownDiscoveryGroup;
	}

	/**
	 * Name of the discovery group used to build the scale-down cluster
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreSlaveHAPolicy scaleDownDiscoveryGroup(String value) {
		this.scaleDownDiscoveryGroup = value;
		return (SharedStoreSlaveHAPolicy) this;
	}

	/**
	 * Name of the group used to scale down.
	 */
	@ModelNodeBinding(detypedName = "scale-down-group-name")
	public String scaleDownGroupName() {
		return this.scaleDownGroupName;
	}

	/**
	 * Name of the group used to scale down.
	 */
	@SuppressWarnings("unchecked")
	public SharedStoreSlaveHAPolicy scaleDownGroupName(String value) {
		this.scaleDownGroupName = value;
		return (SharedStoreSlaveHAPolicy) this;
	}
}