package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.ClassicJSSE;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthorization;
import org.wildfly.swarm.config.security.security_domain.ClassicAudit;
import org.wildfly.swarm.config.security.security_domain.ClassicACL;
import org.wildfly.swarm.config.security.security_domain.JaspiAuthentication;
import org.wildfly.swarm.config.security.security_domain.ClassicMapping;
import org.wildfly.swarm.config.security.security_domain.ClassicIdentityTrust;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthentication;
/**
 * Configures a security domain. Authentication, authorization, ACL, mapping, auditing and identity trust are configured here.
 */
@ResourceType("security-domain")
public class SecurityDomain<T extends SecurityDomain> {

	private String key;
	private String cacheType;
	private ClassicJSSE classicJsse;
	private ClassicAuthorization classicAuthorization;
	private ClassicAudit classicAudit;
	private ClassicACL classicAcl;
	private JaspiAuthentication jaspiAuthentication;
	private ClassicMapping classicMapping;
	private ClassicIdentityTrust classicIdentityTrust;
	private ClassicAuthentication classicAuthentication;

	public SecurityDomain(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a cache to speed up authentication checks. Allowed values are 'default' to use simple map as the cache and 'infinispan' to use an Infinispan cache.
	 */
	@ModelNodeBinding(detypedName = "cache-type")
	public String cacheType() {
		return this.cacheType;
	}

	/**
	 * Adds a cache to speed up authentication checks. Allowed values are 'default' to use simple map as the cache and 'infinispan' to use an Infinispan cache.
	 */
	@SuppressWarnings("unchecked")
	public SecurityDomain cacheType(String value) {
		this.cacheType = value;
		return (SecurityDomain) this;
	}

	/**
	 * JSSE configuration. Configures attributes for keystores that can be used for setting up SSL.
	 */
	@Subresource
	public ClassicJSSE classicJsse() {
		return this.classicJsse;
	}

	/**
	 * JSSE configuration. Configures attributes for keystores that can be used for setting up SSL.
	 */
	@SuppressWarnings("unchecked")
	public SecurityDomain classicJsse(ClassicJSSE value) {
		this.classicJsse = value;
		return (SecurityDomain) this;
	}

	/**
	 * Authorization configuration. Configures a list of authorization policy modules to be used.
	 */
	@Subresource
	public ClassicAuthorization classicAuthorization() {
		return this.classicAuthorization;
	}

	/**
	 * Authorization configuration. Configures a list of authorization policy modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public SecurityDomain classicAuthorization(ClassicAuthorization value) {
		this.classicAuthorization = value;
		return (SecurityDomain) this;
	}

	/**
	 * Auditing configuration. Configures a list of provider modules to be used.
	 */
	@Subresource
	public ClassicAudit classicAudit() {
		return this.classicAudit;
	}

	/**
	 * Auditing configuration. Configures a list of provider modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public SecurityDomain classicAudit(ClassicAudit value) {
		this.classicAudit = value;
		return (SecurityDomain) this;
	}

	/**
	 * Access control list configuration. Configures a list of ACL modules to be used.
	 */
	@Subresource
	public ClassicACL classicAcl() {
		return this.classicAcl;
	}

	/**
	 * Access control list configuration. Configures a list of ACL modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public SecurityDomain classicAcl(ClassicACL value) {
		this.classicAcl = value;
		return (SecurityDomain) this;
	}

	/**
	 * JASPI authentication configuration.
	 */
	@Subresource
	public JaspiAuthentication jaspiAuthentication() {
		return this.jaspiAuthentication;
	}

	/**
	 * JASPI authentication configuration.
	 */
	@SuppressWarnings("unchecked")
	public SecurityDomain jaspiAuthentication(JaspiAuthentication value) {
		this.jaspiAuthentication = value;
		return (SecurityDomain) this;
	}

	/**
	 * Mapping configuration. Configures a list of mapping modules to be used for principal, role, attribute and credential mapping.
	 */
	@Subresource
	public ClassicMapping classicMapping() {
		return this.classicMapping;
	}

	/**
	 * Mapping configuration. Configures a list of mapping modules to be used for principal, role, attribute and credential mapping.
	 */
	@SuppressWarnings("unchecked")
	public SecurityDomain classicMapping(ClassicMapping value) {
		this.classicMapping = value;
		return (SecurityDomain) this;
	}

	/**
	 * Identity trust configuration. Configures a list of trust modules to be used.
	 */
	@Subresource
	public ClassicIdentityTrust classicIdentityTrust() {
		return this.classicIdentityTrust;
	}

	/**
	 * Identity trust configuration. Configures a list of trust modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public SecurityDomain classicIdentityTrust(ClassicIdentityTrust value) {
		this.classicIdentityTrust = value;
		return (SecurityDomain) this;
	}

	/**
	 * Traditional authentication configuration.  Configures a list of login modules to be used.
	 */
	@Subresource
	public ClassicAuthentication classicAuthentication() {
		return this.classicAuthentication;
	}

	/**
	 * Traditional authentication configuration.  Configures a list of login modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public SecurityDomain classicAuthentication(ClassicAuthentication value) {
		this.classicAuthentication = value;
		return (SecurityDomain) this;
	}
}