package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.acl.ACLModule;
import org.wildfly.swarm.config.security.security_domain.acl.ACLModuleConfigurator;
/**
 * Access control list configuration. Configures a list of ACL modules to be used.
 */
@ResourceType("acl")
@Implicit
public class ClassicACL<T extends ClassicACL> {

	private String key;
	private ClassicACLResources subresources = new ClassicACLResources();

	public ClassicACL() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public ClassicACLResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.acl.ACLModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.acl.ACLModule objects.
	 */
	@SuppressWarnings("unchecked")
	public ClassicACL aclModules(
			List<org.wildfly.swarm.config.security.security_domain.acl.ACLModule> value) {
		this.subresources.aclModules = value;
		return (ClassicACL) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.acl.ACLModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.acl.ACLModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicACL aclModule(ACLModule value) {
		this.subresources.aclModules.add(value);
		return (ClassicACL) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.acl.ACLModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.acl.ACLModule resource
	 * @param config The org.wildfly.swarm.config.security.security_domain.acl.ACLModuleConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicACL aclModule(String childKey, ACLModuleConfigurator config) {
		org.wildfly.swarm.config.security.security_domain.acl.ACLModule child = new org.wildfly.swarm.config.security.security_domain.acl.ACLModule(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		aclModule(child);
		return (ClassicACL) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.acl.ACLModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.acl.ACLModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicACL aclModule(String childKey) {
		aclModule(childKey, null);
		return (ClassicACL) this;
	}

	/**
	 * Child mutators for ClassicACL
	 */
	public class ClassicACLResources {
		/**
		 * List of authentication modules
		 */
		private List<org.wildfly.swarm.config.security.security_domain.acl.ACLModule> aclModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.acl.ACLModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ACLModule> aclModules() {
			return this.aclModules;
		}
	}
}