package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * JSSE configuration. Configures attributes for keystores that can be used for setting up SSL.
 */
@ResourceType("jsse")
@Implicit
public class ClassicJSSE<T extends ClassicJSSE> {

	private String key;
	private Map additionalProperties = new java.util.HashMap<String, Object>();
	private String cipherSuites;
	private String clientAlias;
	private Boolean clientAuth;
	private Map keyManager = new java.util.HashMap<String, Object>();
	private Map keystore = new java.util.HashMap<String, Object>();
	private String protocols;
	private String serverAlias;
	private String serviceAuthToken;
	private Map trustManager = new java.util.HashMap<String, Object>();
	private Map truststore = new java.util.HashMap<String, Object>();

	public ClassicJSSE() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Additional properties that may be necessary to configure JSSE.
	 */
	@ModelNodeBinding(detypedName = "additional-properties")
	public Map additionalProperties() {
		return this.additionalProperties;
	}

	/**
	 * Additional properties that may be necessary to configure JSSE.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJSSE additionalProperties(Map value) {
		this.additionalProperties = value;
		return (ClassicJSSE) this;
	}

	/**
	 * Additional properties that may be necessary to configure JSSE.
	 */
	public ClassicJSSE additionalPropertiesEntry(String key, Object value) {
		this.additionalProperties.put(key, value);
		return (ClassicJSSE) this;
	}

	/**
	 * Comma separated list of cipher suites to enable on SSLSockets.
	 */
	@ModelNodeBinding(detypedName = "cipher-suites")
	public String cipherSuites() {
		return this.cipherSuites;
	}

	/**
	 * Comma separated list of cipher suites to enable on SSLSockets.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJSSE cipherSuites(String value) {
		this.cipherSuites = value;
		return (ClassicJSSE) this;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the client alias.
	 */
	@ModelNodeBinding(detypedName = "client-alias")
	public String clientAlias() {
		return this.clientAlias;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the client alias.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJSSE clientAlias(String value) {
		this.clientAlias = value;
		return (ClassicJSSE) this;
	}

	/**
	 * Boolean attribute to indicate if client's certificates should also be authenticated on the server side.
	 */
	@ModelNodeBinding(detypedName = "client-auth")
	public Boolean clientAuth() {
		return this.clientAuth;
	}

	/**
	 * Boolean attribute to indicate if client's certificates should also be authenticated on the server side.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJSSE clientAuth(Boolean value) {
		this.clientAuth = value;
		return (ClassicJSSE) this;
	}

	/**
	 * JSEE Key Manager factory
	 */
	@ModelNodeBinding(detypedName = "key-manager")
	public Map keyManager() {
		return this.keyManager;
	}

	/**
	 * JSEE Key Manager factory
	 */
	@SuppressWarnings("unchecked")
	public ClassicJSSE keyManager(Map value) {
		this.keyManager = value;
		return (ClassicJSSE) this;
	}

	/**
	 * JSEE Key Manager factory
	 */
	public ClassicJSSE keyManagerEntry(String key, Object value) {
		this.keyManager.put(key, value);
		return (ClassicJSSE) this;
	}

	/**
	 * Configures a JSSE key store
	 */
	@ModelNodeBinding(detypedName = "keystore")
	public Map keystore() {
		return this.keystore;
	}

	/**
	 * Configures a JSSE key store
	 */
	@SuppressWarnings("unchecked")
	public ClassicJSSE keystore(Map value) {
		this.keystore = value;
		return (ClassicJSSE) this;
	}

	/**
	 * Configures a JSSE key store
	 */
	public ClassicJSSE keystoreEntry(String key, Object value) {
		this.keystore.put(key, value);
		return (ClassicJSSE) this;
	}

	/**
	 * Comma separated list of protocols to enable on SSLSockets.
	 */
	@ModelNodeBinding(detypedName = "protocols")
	public String protocols() {
		return this.protocols;
	}

	/**
	 * Comma separated list of protocols to enable on SSLSockets.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJSSE protocols(String value) {
		this.protocols = value;
		return (ClassicJSSE) this;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the server alias.
	 */
	@ModelNodeBinding(detypedName = "server-alias")
	public String serverAlias() {
		return this.serverAlias;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the server alias.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJSSE serverAlias(String value) {
		this.serverAlias = value;
		return (ClassicJSSE) this;
	}

	/**
	 * Token to retrieve PrivateKeys from the KeyStore.
	 */
	@ModelNodeBinding(detypedName = "service-auth-token")
	public String serviceAuthToken() {
		return this.serviceAuthToken;
	}

	/**
	 * Token to retrieve PrivateKeys from the KeyStore.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJSSE serviceAuthToken(String value) {
		this.serviceAuthToken = value;
		return (ClassicJSSE) this;
	}

	/**
	 * JSEE Trust Manager factory
	 */
	@ModelNodeBinding(detypedName = "trust-manager")
	public Map trustManager() {
		return this.trustManager;
	}

	/**
	 * JSEE Trust Manager factory
	 */
	@SuppressWarnings("unchecked")
	public ClassicJSSE trustManager(Map value) {
		this.trustManager = value;
		return (ClassicJSSE) this;
	}

	/**
	 * JSEE Trust Manager factory
	 */
	public ClassicJSSE trustManagerEntry(String key, Object value) {
		this.trustManager.put(key, value);
		return (ClassicJSSE) this;
	}

	/**
	 * Configures a JSSE trust store
	 */
	@ModelNodeBinding(detypedName = "truststore")
	public Map truststore() {
		return this.truststore;
	}

	/**
	 * Configures a JSSE trust store
	 */
	@SuppressWarnings("unchecked")
	public ClassicJSSE truststore(Map value) {
		this.truststore = value;
		return (ClassicJSSE) this;
	}

	/**
	 * Configures a JSSE trust store
	 */
	public ClassicJSSE truststoreEntry(String key, Object value) {
		this.truststore.put(key, value);
		return (ClassicJSSE) this;
	}
}