package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStackConfigurator;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModule;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModuleConfigurator;
/**
 * JASPI authentication configuration.
 */
@ResourceType("authentication")
@Implicit
public class JaspiAuthentication<T extends JaspiAuthentication> {

	private String key;
	private JaspiAuthenticationResources subresources = new JaspiAuthenticationResources();

	public JaspiAuthentication() {
		this.key = "jaspi";
	}

	public String getKey() {
		return this.key;
	}

	public JaspiAuthenticationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack objects.
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication loginModuleStacks(
			List<org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack> value) {
		this.subresources.loginModuleStacks = value;
		return (JaspiAuthentication) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication loginModuleStack(LoginModuleStack value) {
		this.subresources.loginModuleStacks.add(value);
		return (JaspiAuthentication) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack resource
	 * @param config The org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStackConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication loginModuleStack(String childKey,
			LoginModuleStackConfigurator config) {
		org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack child = new org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		loginModuleStack(child);
		return (JaspiAuthentication) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication loginModuleStack(String childKey) {
		loginModuleStack(childKey, null);
		return (JaspiAuthentication) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.authentication.AuthModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.authentication.AuthModule objects.
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication authModules(
			List<org.wildfly.swarm.config.security.security_domain.authentication.AuthModule> value) {
		this.subresources.authModules = value;
		return (JaspiAuthentication) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.authentication.AuthModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.authentication.AuthModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication authModule(AuthModule value) {
		this.subresources.authModules.add(value);
		return (JaspiAuthentication) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.authentication.AuthModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.authentication.AuthModule resource
	 * @param config The org.wildfly.swarm.config.security.security_domain.authentication.AuthModuleConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication authModule(String childKey,
			AuthModuleConfigurator config) {
		org.wildfly.swarm.config.security.security_domain.authentication.AuthModule child = new org.wildfly.swarm.config.security.security_domain.authentication.AuthModule(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		authModule(child);
		return (JaspiAuthentication) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.authentication.AuthModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.authentication.AuthModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication authModule(String childKey) {
		authModule(childKey, null);
		return (JaspiAuthentication) this;
	}

	/**
	 * Child mutators for JaspiAuthentication
	 */
	public class JaspiAuthenticationResources {
		/**
		 * List of "named" login modules that are used by jaspi authentication modules.
		 */
		private List<org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack> loginModuleStacks = new java.util.ArrayList<>();
		/**
		 * List of modules that map principal, role, and credential information
		 */
		private List<org.wildfly.swarm.config.security.security_domain.authentication.AuthModule> authModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LoginModuleStack> loginModuleStacks() {
			return this.loginModuleStacks;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.authentication.AuthModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AuthModule> authModules() {
			return this.authModules;
		}
	}
}