package org.wildfly.swarm.config.security.security_domain.audit;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * List of modules that map principal, role, and credential information
 */
@ResourceType("provider-module")
public class ProviderModule<T extends ProviderModule> {

	private String key;
	private String code;
	private Map moduleOptions = new java.util.HashMap<String, Object>();

	public ProviderModule(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@SuppressWarnings("unchecked")
	public ProviderModule code(String value) {
		this.code = value;
		return (ProviderModule) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@ModelNodeBinding(detypedName = "module-options")
	public Map moduleOptions() {
		return this.moduleOptions;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public ProviderModule moduleOptions(Map value) {
		this.moduleOptions = value;
		return (ProviderModule) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	public ProviderModule moduleOptionsEntry(String key, Object value) {
		this.moduleOptions.put(key, value);
		return (ProviderModule) this;
	}
}