package org.wildfly.swarm.config.security.security_domain.authentication;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * List of authentication modules
 */
@ResourceType("login-module")
public class LoginModule<T extends LoginModule> {

	private String key;
	private String code;
	private String flag;
	private String module;
	private Map moduleOptions = new java.util.HashMap<String, Object>();

	public LoginModule(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@SuppressWarnings("unchecked")
	public LoginModule code(String value) {
		this.code = value;
		return (LoginModule) this;
	}

	/**
	 * The flag controls how the module participates in the overall procedure. Allowed values are requisite, required, sufficient or optional.
	 */
	@ModelNodeBinding(detypedName = "flag")
	public String flag() {
		return this.flag;
	}

	/**
	 * The flag controls how the module participates in the overall procedure. Allowed values are requisite, required, sufficient or optional.
	 */
	@SuppressWarnings("unchecked")
	public LoginModule flag(String value) {
		this.flag = value;
		return (LoginModule) this;
	}

	/**
	 * Name of JBoss Module where the login module is located.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Name of JBoss Module where the login module is located.
	 */
	@SuppressWarnings("unchecked")
	public LoginModule module(String value) {
		this.module = value;
		return (LoginModule) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@ModelNodeBinding(detypedName = "module-options")
	public Map moduleOptions() {
		return this.moduleOptions;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public LoginModule moduleOptions(Map value) {
		this.moduleOptions = value;
		return (LoginModule) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	public LoginModule moduleOptionsEntry(String key, Object value) {
		this.moduleOptions.put(key, value);
		return (LoginModule) this;
	}
}