package org.wildfly.swarm.config.security.security_domain.authentication;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
/**
 * List of "named" login modules that are used by jaspi authentication modules.
 */
@ResourceType("login-module-stack")
public class LoginModuleStack<T extends LoginModuleStack> {

	private String key;
	private LoginModuleStackResources subresources = new LoginModuleStackResources();

	public LoginModuleStack(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	public LoginModuleStackResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.authentication.LoginModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.authentication.LoginModule objects.
	 */
	@SuppressWarnings("unchecked")
	public LoginModuleStack loginModules(
			List<org.wildfly.swarm.config.security.security_domain.authentication.LoginModule> value) {
		this.subresources.loginModules = value;
		return (LoginModuleStack) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.authentication.LoginModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.authentication.LoginModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoginModuleStack loginModule(LoginModule value) {
		this.subresources.loginModules.add(value);
		return (LoginModuleStack) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.authentication.LoginModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.authentication.LoginModule resource
	 * @param config The org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoginModuleStack loginModule(String childKey,
			LoginModuleConfigurator config) {
		org.wildfly.swarm.config.security.security_domain.authentication.LoginModule child = new org.wildfly.swarm.config.security.security_domain.authentication.LoginModule(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		loginModule(child);
		return (LoginModuleStack) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.authentication.LoginModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.authentication.LoginModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LoginModuleStack loginModule(String childKey) {
		loginModule(childKey, null);
		return (LoginModuleStack) this;
	}

	/**
	 * Child mutators for LoginModuleStack
	 */
	public class LoginModuleStackResources {
		/**
		 * List of authentication modules
		 */
		private List<org.wildfly.swarm.config.security.security_domain.authentication.LoginModule> loginModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.authentication.LoginModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LoginModule> loginModules() {
			return this.loginModules;
		}
	}
}