package org.wildfly.swarm.config.security.security_domain.identity_trust;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * List of authentication modules
 */
@ResourceType("trust-module")
public class TrustModule<T extends TrustModule> {

	private String key;
	private String code;
	private String flag;
	private String module;
	private Map moduleOptions = new java.util.HashMap<String, Object>();

	public TrustModule(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@SuppressWarnings("unchecked")
	public TrustModule code(String value) {
		this.code = value;
		return (TrustModule) this;
	}

	/**
	 * The flag controls how the module participates in the overall procedure. Allowed values are requisite, required, sufficient or optional.
	 */
	@ModelNodeBinding(detypedName = "flag")
	public String flag() {
		return this.flag;
	}

	/**
	 * The flag controls how the module participates in the overall procedure. Allowed values are requisite, required, sufficient or optional.
	 */
	@SuppressWarnings("unchecked")
	public TrustModule flag(String value) {
		this.flag = value;
		return (TrustModule) this;
	}

	/**
	 * Name of JBoss Module where the login module is located.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Name of JBoss Module where the login module is located.
	 */
	@SuppressWarnings("unchecked")
	public TrustModule module(String value) {
		this.module = value;
		return (TrustModule) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@ModelNodeBinding(detypedName = "module-options")
	public Map moduleOptions() {
		return this.moduleOptions;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public TrustModule moduleOptions(Map value) {
		this.moduleOptions = value;
		return (TrustModule) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	public TrustModule moduleOptionsEntry(String key, Object value) {
		this.moduleOptions.put(key, value);
		return (TrustModule) this;
	}
}