package org.wildfly.swarm.config.transactions;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.transactions.log_store.Transactions;
import org.wildfly.swarm.config.transactions.log_store.TransactionsConfigurator;
/**
 * Representation of the transaction logging storage mechanism.
 */
@ResourceType("log-store")
@Implicit
public class LogStore<T extends LogStore> {

	private String key;
	private Boolean exposeAllLogs;
	private String type;
	private LogStoreResources subresources = new LogStoreResources();

	public LogStore() {
		this.key = "log-store";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether to expose all logs like orphans etc. By default only a subset of transaction logs is exposed.
	 */
	@ModelNodeBinding(detypedName = "expose-all-logs")
	public Boolean exposeAllLogs() {
		return this.exposeAllLogs;
	}

	/**
	 * Whether to expose all logs like orphans etc. By default only a subset of transaction logs is exposed.
	 */
	@SuppressWarnings("unchecked")
	public LogStore exposeAllLogs(Boolean value) {
		this.exposeAllLogs = value;
		return (LogStore) this;
	}

	/**
	 * Specifies the implementation type of the logging store.
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * Specifies the implementation type of the logging store.
	 */
	@SuppressWarnings("unchecked")
	public LogStore type(String value) {
		this.type = value;
		return (LogStore) this;
	}

	public LogStoreResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.transactions.log_store.Transactions objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.transactions.log_store.Transactions objects.
	 */
	@SuppressWarnings("unchecked")
	public LogStore transactions(
			List<org.wildfly.swarm.config.transactions.log_store.Transactions> value) {
		this.subresources.transactions = value;
		return (LogStore) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.transactions.log_store.Transactions object to the list of subresources
	 * @param value The org.wildfly.swarm.config.transactions.log_store.Transactions to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LogStore transactions(Transactions value) {
		this.subresources.transactions.add(value);
		return (LogStore) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.transactions.log_store.Transactions object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.transactions.log_store.Transactions resource
	 * @param config The org.wildfly.swarm.config.transactions.log_store.TransactionsConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LogStore transactions(String childKey,
			TransactionsConfigurator config) {
		org.wildfly.swarm.config.transactions.log_store.Transactions child = new org.wildfly.swarm.config.transactions.log_store.Transactions(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		transactions(child);
		return (LogStore) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.transactions.log_store.Transactions object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.transactions.log_store.Transactions resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public LogStore transactions(String childKey) {
		transactions(childKey, null);
		return (LogStore) this;
	}

	/**
	 * Child mutators for LogStore
	 */
	public class LogStoreResources {
		/**
		 * The persistent information that the transaction manager stores for the purpose of recovering a transaction in the event of failure. The probe operation will add and remove transactions from the model as the corresponding real transactions start and finish the prepare and commit phases. A stuck transaction will remain in the model until either it is completed or explicitly removed by the delete operation.
		 */
		private List<org.wildfly.swarm.config.transactions.log_store.Transactions> transactions = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.transactions.log_store.Transactions resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Transactions> transactions() {
			return this.transactions;
		}
	}
}