package org.wildfly.swarm.config.undertow.configuration.mod_cluster;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.NodeConfigurator;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroupConfigurator;
/**
 * Runtime representation of a mod_cluster balancer
 */
@ResourceType("balancer")
public class Balancer<T extends Balancer> {

	private String key;
	private Integer maxAttempts;
	private Boolean stickySession;
	private String stickySessionCookie;
	private Boolean stickySessionForce;
	private String stickySessionPath;
	private Boolean stickySessionRemove;
	private Integer waitWorker;
	private BalancerResources subresources = new BalancerResources();

	public Balancer(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of attempts to send the request to a backend server
	 */
	@ModelNodeBinding(detypedName = "max-attempts")
	public Integer maxAttempts() {
		return this.maxAttempts;
	}

	/**
	 * The number of attempts to send the request to a backend server
	 */
	@SuppressWarnings("unchecked")
	public Balancer maxAttempts(Integer value) {
		this.maxAttempts = value;
		return (Balancer) this;
	}

	/**
	 * If sticky sessions are enabled
	 */
	@ModelNodeBinding(detypedName = "sticky-session")
	public Boolean stickySession() {
		return this.stickySession;
	}

	/**
	 * If sticky sessions are enabled
	 */
	@SuppressWarnings("unchecked")
	public Balancer stickySession(Boolean value) {
		this.stickySession = value;
		return (Balancer) this;
	}

	/**
	 * The session cookie name
	 */
	@ModelNodeBinding(detypedName = "sticky-session-cookie")
	public String stickySessionCookie() {
		return this.stickySessionCookie;
	}

	/**
	 * The session cookie name
	 */
	@SuppressWarnings("unchecked")
	public Balancer stickySessionCookie(String value) {
		this.stickySessionCookie = value;
		return (Balancer) this;
	}

	/**
	 * If this is true then an error will be returned if the request cannot be routed to the sticky node, otherwise it will be routed to another node
	 */
	@ModelNodeBinding(detypedName = "sticky-session-force")
	public Boolean stickySessionForce() {
		return this.stickySessionForce;
	}

	/**
	 * If this is true then an error will be returned if the request cannot be routed to the sticky node, otherwise it will be routed to another node
	 */
	@SuppressWarnings("unchecked")
	public Balancer stickySessionForce(Boolean value) {
		this.stickySessionForce = value;
		return (Balancer) this;
	}

	/**
	 * The path of the sticky session cookie
	 */
	@ModelNodeBinding(detypedName = "sticky-session-path")
	public String stickySessionPath() {
		return this.stickySessionPath;
	}

	/**
	 * The path of the sticky session cookie
	 */
	@SuppressWarnings("unchecked")
	public Balancer stickySessionPath(String value) {
		this.stickySessionPath = value;
		return (Balancer) this;
	}

	/**
	 * Remove the session cookie if the request cannot be routed to the correct host
	 */
	@ModelNodeBinding(detypedName = "sticky-session-remove")
	public Boolean stickySessionRemove() {
		return this.stickySessionRemove;
	}

	/**
	 * Remove the session cookie if the request cannot be routed to the correct host
	 */
	@SuppressWarnings("unchecked")
	public Balancer stickySessionRemove(Boolean value) {
		this.stickySessionRemove = value;
		return (Balancer) this;
	}

	/**
	 * The number of seconds to wait for an available worker
	 */
	@ModelNodeBinding(detypedName = "wait-worker")
	public Integer waitWorker() {
		return this.waitWorker;
	}

	/**
	 * The number of seconds to wait for an available worker
	 */
	@SuppressWarnings("unchecked")
	public Balancer waitWorker(Integer value) {
		this.waitWorker = value;
		return (Balancer) this;
	}

	public BalancerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node objects.
	 */
	@SuppressWarnings("unchecked")
	public Balancer nodes(
			List<org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node> value) {
		this.subresources.nodes = value;
		return (Balancer) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Balancer node(Node value) {
		this.subresources.nodes.add(value);
		return (Balancer) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node resource
	 * @param config The org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.NodeConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Balancer node(String childKey, NodeConfigurator config) {
		org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node child = new org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		node(child);
		return (Balancer) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Balancer node(String childKey) {
		node(childKey, null);
		return (Balancer) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public Balancer loadBalancingGroups(
			List<org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup> value) {
		this.subresources.loadBalancingGroups = value;
		return (Balancer) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Balancer loadBalancingGroup(LoadBalancingGroup value) {
		this.subresources.loadBalancingGroups.add(value);
		return (Balancer) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup resource
	 * @param config The org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroupConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Balancer loadBalancingGroup(String childKey,
			LoadBalancingGroupConfigurator config) {
		org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup child = new org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		loadBalancingGroup(child);
		return (Balancer) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Balancer loadBalancingGroup(String childKey) {
		loadBalancingGroup(childKey, null);
		return (Balancer) this;
	}

	/**
	 * Child mutators for Balancer
	 */
	public class BalancerResources {
		/**
		 * Runtime representation of a mod_cluster node
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node> nodes = new java.util.ArrayList<>();
		/**
		 * A load balancing group
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup> loadBalancingGroups = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Node> nodes() {
			return this.nodes;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LoadBalancingGroup> loadBalancingGroups() {
			return this.loadBalancingGroups;
		}
	}
}