package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
/**
 * Holds configuration of location resource
 */
@ResourceType("location")
public class Location<T extends Location> {

	private String key;
	private String handler;
	private LocationResources subresources = new LocationResources();

	public Location(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Default handler for this location
	 */
	@ModelNodeBinding(detypedName = "handler")
	public String handler() {
		return this.handler;
	}

	/**
	 * Default handler for this location
	 */
	@SuppressWarnings("unchecked")
	public Location handler(String value) {
		this.handler = value;
		return (Location) this;
	}

	public LocationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.server.host.FilterRef objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.server.host.FilterRef objects.
	 */
	@SuppressWarnings("unchecked")
	public Location filterRefs(
			List<org.wildfly.swarm.config.undertow.server.host.FilterRef> value) {
		this.subresources.filterRefs = value;
		return (Location) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.server.host.FilterRef object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.server.host.FilterRef to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Location filterRef(FilterRef value) {
		this.subresources.filterRefs.add(value);
		return (Location) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.host.FilterRef object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.host.FilterRef resource
	 * @param config The org.wildfly.swarm.config.undertow.server.host.FilterRefConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Location filterRef(String childKey, FilterRefConfigurator config) {
		org.wildfly.swarm.config.undertow.server.host.FilterRef child = new org.wildfly.swarm.config.undertow.server.host.FilterRef(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		filterRef(child);
		return (Location) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.host.FilterRef object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.host.FilterRef resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Location filterRef(String childKey) {
		filterRef(childKey, null);
		return (Location) this;
	}

	/**
	 * Child mutators for Location
	 */
	public class LocationResources {
		/**
		 * Reference to filter
		 */
		private List<org.wildfly.swarm.config.undertow.server.host.FilterRef> filterRefs = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.server.host.FilterRef resources
		 * @return the list of resources
		 */
		@Subresource
		public List<FilterRef> filterRefs() {
			return this.filterRefs;
		}
	}
}