package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * JSP container configuration.
 */
@ResourceType("setting")
@Implicit
public class JSPSetting<T extends JSPSetting> {

	private String key;
	private Integer checkInterval;
	private Boolean development;
	private Boolean disabled;
	private Boolean displaySourceFragment;
	private Boolean dumpSmap;
	private Boolean errorOnUseBeanInvalidClassAttribute;
	private Boolean generateStringsAsCharArrays;
	private String javaEncoding;
	private Boolean keepGenerated;
	private Boolean mappedFile;
	private Integer modificationTestInterval;
	private Boolean optimizeScriptlets;
	private Boolean recompileOnFail;
	private String scratchDir;
	private Boolean smap;
	private String sourceVm;
	private Boolean tagPooling;
	private String targetVm;
	private Boolean trimSpaces;
	private Boolean xPoweredBy;

	public JSPSetting() {
		this.key = "jsp";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Check interval for JSP updates using a background thread.
	 */
	@ModelNodeBinding(detypedName = "check-interval")
	public Integer checkInterval() {
		return this.checkInterval;
	}

	/**
	 * Check interval for JSP updates using a background thread.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting checkInterval(Integer value) {
		this.checkInterval = value;
		return (JSPSetting) this;
	}

	/**
	 * Enable Development mode which enables reloading JSP on-the-fly
	 */
	@ModelNodeBinding(detypedName = "development")
	public Boolean development() {
		return this.development;
	}

	/**
	 * Enable Development mode which enables reloading JSP on-the-fly
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting development(Boolean value) {
		this.development = value;
		return (JSPSetting) this;
	}

	/**
	 * Enable the JSP container.
	 */
	@ModelNodeBinding(detypedName = "disabled")
	public Boolean disabled() {
		return this.disabled;
	}

	/**
	 * Enable the JSP container.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting disabled(Boolean value) {
		this.disabled = value;
		return (JSPSetting) this;
	}

	/**
	 * When a runtime error occurs, attempts to display corresponding JSP source fragment
	 */
	@ModelNodeBinding(detypedName = "display-source-fragment")
	public Boolean displaySourceFragment() {
		return this.displaySourceFragment;
	}

	/**
	 * When a runtime error occurs, attempts to display corresponding JSP source fragment
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting displaySourceFragment(Boolean value) {
		this.displaySourceFragment = value;
		return (JSPSetting) this;
	}

	/**
	 * Write SMAP data to a file.
	 */
	@ModelNodeBinding(detypedName = "dump-smap")
	public Boolean dumpSmap() {
		return this.dumpSmap;
	}

	/**
	 * Write SMAP data to a file.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting dumpSmap(Boolean value) {
		this.dumpSmap = value;
		return (JSPSetting) this;
	}

	/**
	 * Enable errors when using a bad class in useBean.
	 */
	@ModelNodeBinding(detypedName = "error-on-use-bean-invalid-class-attribute")
	public Boolean errorOnUseBeanInvalidClassAttribute() {
		return this.errorOnUseBeanInvalidClassAttribute;
	}

	/**
	 * Enable errors when using a bad class in useBean.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting errorOnUseBeanInvalidClassAttribute(Boolean value) {
		this.errorOnUseBeanInvalidClassAttribute = value;
		return (JSPSetting) this;
	}

	/**
	 * Generate String constants as char arrays.
	 */
	@ModelNodeBinding(detypedName = "generate-strings-as-char-arrays")
	public Boolean generateStringsAsCharArrays() {
		return this.generateStringsAsCharArrays;
	}

	/**
	 * Generate String constants as char arrays.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting generateStringsAsCharArrays(Boolean value) {
		this.generateStringsAsCharArrays = value;
		return (JSPSetting) this;
	}

	/**
	 * Specify the encoding used for Java sources.
	 */
	@ModelNodeBinding(detypedName = "java-encoding")
	public String javaEncoding() {
		return this.javaEncoding;
	}

	/**
	 * Specify the encoding used for Java sources.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting javaEncoding(String value) {
		this.javaEncoding = value;
		return (JSPSetting) this;
	}

	/**
	 * Keep the generated Servlets.
	 */
	@ModelNodeBinding(detypedName = "keep-generated")
	public Boolean keepGenerated() {
		return this.keepGenerated;
	}

	/**
	 * Keep the generated Servlets.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting keepGenerated(Boolean value) {
		this.keepGenerated = value;
		return (JSPSetting) this;
	}

	/**
	 * Map to the JSP source.
	 */
	@ModelNodeBinding(detypedName = "mapped-file")
	public Boolean mappedFile() {
		return this.mappedFile;
	}

	/**
	 * Map to the JSP source.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting mappedFile(Boolean value) {
		this.mappedFile = value;
		return (JSPSetting) this;
	}

	/**
	 * Minimum amount of time between two tests for updates, in seconds.
	 */
	@ModelNodeBinding(detypedName = "modification-test-interval")
	public Integer modificationTestInterval() {
		return this.modificationTestInterval;
	}

	/**
	 * Minimum amount of time between two tests for updates, in seconds.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting modificationTestInterval(Integer value) {
		this.modificationTestInterval = value;
		return (JSPSetting) this;
	}

	/**
	 * If JSP scriptlets should be optimised to remove string concatenation
	 */
	@ModelNodeBinding(detypedName = "optimize-scriptlets")
	public Boolean optimizeScriptlets() {
		return this.optimizeScriptlets;
	}

	/**
	 * If JSP scriptlets should be optimised to remove string concatenation
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting optimizeScriptlets(Boolean value) {
		this.optimizeScriptlets = value;
		return (JSPSetting) this;
	}

	/**
	 * Retry failed JSP compilations on each request.
	 */
	@ModelNodeBinding(detypedName = "recompile-on-fail")
	public Boolean recompileOnFail() {
		return this.recompileOnFail;
	}

	/**
	 * Retry failed JSP compilations on each request.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting recompileOnFail(Boolean value) {
		this.recompileOnFail = value;
		return (JSPSetting) this;
	}

	/**
	 * Specify a different work directory.
	 */
	@ModelNodeBinding(detypedName = "scratch-dir")
	public String scratchDir() {
		return this.scratchDir;
	}

	/**
	 * Specify a different work directory.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting scratchDir(String value) {
		this.scratchDir = value;
		return (JSPSetting) this;
	}

	/**
	 * Enable SMAP.
	 */
	@ModelNodeBinding(detypedName = "smap")
	public Boolean smap() {
		return this.smap;
	}

	/**
	 * Enable SMAP.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting smap(Boolean value) {
		this.smap = value;
		return (JSPSetting) this;
	}

	/**
	 * Source VM level for compilation.
	 */
	@ModelNodeBinding(detypedName = "source-vm")
	public String sourceVm() {
		return this.sourceVm;
	}

	/**
	 * Source VM level for compilation.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting sourceVm(String value) {
		this.sourceVm = value;
		return (JSPSetting) this;
	}

	/**
	 * Enable tag pooling.
	 */
	@ModelNodeBinding(detypedName = "tag-pooling")
	public Boolean tagPooling() {
		return this.tagPooling;
	}

	/**
	 * Enable tag pooling.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting tagPooling(Boolean value) {
		this.tagPooling = value;
		return (JSPSetting) this;
	}

	/**
	 * Target VM level for compilation.
	 */
	@ModelNodeBinding(detypedName = "target-vm")
	public String targetVm() {
		return this.targetVm;
	}

	/**
	 * Target VM level for compilation.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting targetVm(String value) {
		this.targetVm = value;
		return (JSPSetting) this;
	}

	/**
	 * Trim some spaces from the generated Servlet.
	 */
	@ModelNodeBinding(detypedName = "trim-spaces")
	public Boolean trimSpaces() {
		return this.trimSpaces;
	}

	/**
	 * Trim some spaces from the generated Servlet.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting trimSpaces(Boolean value) {
		this.trimSpaces = value;
		return (JSPSetting) this;
	}

	/**
	 * Enable advertising the JSP engine in x-powered-by.
	 */
	@ModelNodeBinding(detypedName = "x-powered-by")
	public Boolean xPoweredBy() {
		return this.xPoweredBy;
	}

	/**
	 * Enable advertising the JSP engine in x-powered-by.
	 */
	@SuppressWarnings("unchecked")
	public JSPSetting xPoweredBy(Boolean value) {
		this.xPoweredBy = value;
		return (JSPSetting) this;
	}
}