package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * If websockets are enabled for this container
 */
@ResourceType("setting")
@Implicit
public class WebsocketsSetting<T extends WebsocketsSetting> {

	private String key;
	private String bufferPool;
	private Boolean dispatchToWorker;
	private String worker;

	public WebsocketsSetting() {
		this.key = "websockets";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The buffer pool to use for websocket deployments
	 */
	@ModelNodeBinding(detypedName = "buffer-pool")
	public String bufferPool() {
		return this.bufferPool;
	}

	/**
	 * The buffer pool to use for websocket deployments
	 */
	@SuppressWarnings("unchecked")
	public WebsocketsSetting bufferPool(String value) {
		this.bufferPool = value;
		return (WebsocketsSetting) this;
	}

	/**
	 * If callbacks should be dispatched to a worker thread. If this is false then they will be run in the IO thread, which is faster however care must be taken not to perform blocking operations.
	 */
	@ModelNodeBinding(detypedName = "dispatch-to-worker")
	public Boolean dispatchToWorker() {
		return this.dispatchToWorker;
	}

	/**
	 * If callbacks should be dispatched to a worker thread. If this is false then they will be run in the IO thread, which is faster however care must be taken not to perform blocking operations.
	 */
	@SuppressWarnings("unchecked")
	public WebsocketsSetting dispatchToWorker(Boolean value) {
		this.dispatchToWorker = value;
		return (WebsocketsSetting) this;
	}

	/**
	 * The worker to use for websocket deployments
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * The worker to use for websocket deployments
	 */
	@SuppressWarnings("unchecked")
	public WebsocketsSetting worker(String value) {
		this.worker = value;
		return (WebsocketsSetting) this;
	}
}