/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.messaging_activemq.JMSBridge;
import org.wildfly.swarm.config.messaging_activemq.JMSBridgeConfigurator;
import org.wildfly.swarm.config.messaging_activemq.Server;
import org.wildfly.swarm.config.messaging_activemq.ServerConfigurator;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@ResourceType(value="subsystem")
@Implicit
public class MessagingActiveMQ<T extends MessagingActiveMQ> {
    private String key = "messaging-activemq";
    private MessagingActiveMQResources subresources = new MessagingActiveMQResources();

    public String getKey() {
        return this.key;
    }

    public MessagingActiveMQResources subresources() {
        return this.subresources;
    }

    public T servers(List<Server> value) {
        this.subresources.servers = value;
        return (T)this;
    }

    public T server(Server value) {
        this.subresources.servers.add(value);
        return (T)this;
    }

    public T server(String childKey, ServerConfigurator config) {
        Server child = new Server(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.server(child);
        return (T)this;
    }

    public T server(String childKey) {
        this.server(childKey, null);
        return (T)this;
    }

    public T jmsBridges(List<JMSBridge> value) {
        this.subresources.jmsBridges = value;
        return (T)this;
    }

    public T jmsBridge(JMSBridge value) {
        this.subresources.jmsBridges.add(value);
        return (T)this;
    }

    public T jmsBridge(String childKey, JMSBridgeConfigurator config) {
        JMSBridge child = new JMSBridge(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.jmsBridge(child);
        return (T)this;
    }

    public T jmsBridge(String childKey) {
        this.jmsBridge(childKey, null);
        return (T)this;
    }

    public class MessagingActiveMQResources {
        private List<Server> servers = new ArrayList<Server>();
        private List<JMSBridge> jmsBridges = new ArrayList<JMSBridge>();

        @Subresource
        public List<Server> servers() {
            return this.servers;
        }

        @Subresource
        public List<JMSBridge> jmsBridges() {
            return this.jmsBridges;
        }
    }
}

