/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.ConnectionLimit;
import org.wildfly.swarm.config.undertow.configuration.ConnectionLimitConfigurator;
import org.wildfly.swarm.config.undertow.configuration.CustomFilter;
import org.wildfly.swarm.config.undertow.configuration.CustomFilterConfigurator;
import org.wildfly.swarm.config.undertow.configuration.ErrorPage;
import org.wildfly.swarm.config.undertow.configuration.ErrorPageConfigurator;
import org.wildfly.swarm.config.undertow.configuration.ExpressionFilter;
import org.wildfly.swarm.config.undertow.configuration.ExpressionFilterConfigurator;
import org.wildfly.swarm.config.undertow.configuration.Gzip;
import org.wildfly.swarm.config.undertow.configuration.GzipConfigurator;
import org.wildfly.swarm.config.undertow.configuration.ModCluster;
import org.wildfly.swarm.config.undertow.configuration.ModClusterConfigurator;
import org.wildfly.swarm.config.undertow.configuration.ResponseHeader;
import org.wildfly.swarm.config.undertow.configuration.ResponseHeaderConfigurator;
import org.wildfly.swarm.config.undertow.configuration.Rewrite;
import org.wildfly.swarm.config.undertow.configuration.RewriteConfigurator;

@ResourceType(value="configuration")
@Implicit
public class FilterConfiguration<T extends FilterConfiguration> {
    private String key = "filter";
    private FilterConfigurationResources subresources = new FilterConfigurationResources();

    public String getKey() {
        return this.key;
    }

    public FilterConfigurationResources subresources() {
        return this.subresources;
    }

    public FilterConfiguration errorPages(List<ErrorPage> value) {
        this.subresources.errorPages = value;
        return this;
    }

    public FilterConfiguration errorPage(ErrorPage value) {
        this.subresources.errorPages.add(value);
        return this;
    }

    public FilterConfiguration errorPage(String childKey, ErrorPageConfigurator config) {
        ErrorPage child = new ErrorPage(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.errorPage(child);
        return this;
    }

    public FilterConfiguration errorPage(String childKey) {
        this.errorPage(childKey, null);
        return this;
    }

    public FilterConfiguration customFilters(List<CustomFilter> value) {
        this.subresources.customFilters = value;
        return this;
    }

    public FilterConfiguration customFilter(CustomFilter value) {
        this.subresources.customFilters.add(value);
        return this;
    }

    public FilterConfiguration customFilter(String childKey, CustomFilterConfigurator config) {
        CustomFilter child = new CustomFilter(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.customFilter(child);
        return this;
    }

    public FilterConfiguration customFilter(String childKey) {
        this.customFilter(childKey, null);
        return this;
    }

    public FilterConfiguration gzips(List<Gzip> value) {
        this.subresources.gzips = value;
        return this;
    }

    public FilterConfiguration gzip(Gzip value) {
        this.subresources.gzips.add(value);
        return this;
    }

    public FilterConfiguration gzip(String childKey, GzipConfigurator config) {
        Gzip child = new Gzip(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.gzip(child);
        return this;
    }

    public FilterConfiguration gzip(String childKey) {
        this.gzip(childKey, null);
        return this;
    }

    public FilterConfiguration modClusters(List<ModCluster> value) {
        this.subresources.modClusters = value;
        return this;
    }

    public FilterConfiguration modCluster(ModCluster value) {
        this.subresources.modClusters.add(value);
        return this;
    }

    public FilterConfiguration modCluster(String childKey, ModClusterConfigurator config) {
        ModCluster child = new ModCluster(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.modCluster(child);
        return this;
    }

    public FilterConfiguration modCluster(String childKey) {
        this.modCluster(childKey, null);
        return this;
    }

    public FilterConfiguration expressionFilters(List<ExpressionFilter> value) {
        this.subresources.expressionFilters = value;
        return this;
    }

    public FilterConfiguration expressionFilter(ExpressionFilter value) {
        this.subresources.expressionFilters.add(value);
        return this;
    }

    public FilterConfiguration expressionFilter(String childKey, ExpressionFilterConfigurator config) {
        ExpressionFilter child = new ExpressionFilter(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.expressionFilter(child);
        return this;
    }

    public FilterConfiguration expressionFilter(String childKey) {
        this.expressionFilter(childKey, null);
        return this;
    }

    public FilterConfiguration responseHeaders(List<ResponseHeader> value) {
        this.subresources.responseHeaders = value;
        return this;
    }

    public FilterConfiguration responseHeader(ResponseHeader value) {
        this.subresources.responseHeaders.add(value);
        return this;
    }

    public FilterConfiguration responseHeader(String childKey, ResponseHeaderConfigurator config) {
        ResponseHeader child = new ResponseHeader(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.responseHeader(child);
        return this;
    }

    public FilterConfiguration responseHeader(String childKey) {
        this.responseHeader(childKey, null);
        return this;
    }

    public FilterConfiguration rewrites(List<Rewrite> value) {
        this.subresources.rewrites = value;
        return this;
    }

    public FilterConfiguration rewrite(Rewrite value) {
        this.subresources.rewrites.add(value);
        return this;
    }

    public FilterConfiguration rewrite(String childKey, RewriteConfigurator config) {
        Rewrite child = new Rewrite(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.rewrite(child);
        return this;
    }

    public FilterConfiguration rewrite(String childKey) {
        this.rewrite(childKey, null);
        return this;
    }

    public FilterConfiguration connectionLimits(List<ConnectionLimit> value) {
        this.subresources.connectionLimits = value;
        return this;
    }

    public FilterConfiguration connectionLimit(ConnectionLimit value) {
        this.subresources.connectionLimits.add(value);
        return this;
    }

    public FilterConfiguration connectionLimit(String childKey, ConnectionLimitConfigurator config) {
        ConnectionLimit child = new ConnectionLimit(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.connectionLimit(child);
        return this;
    }

    public FilterConfiguration connectionLimit(String childKey) {
        this.connectionLimit(childKey, null);
        return this;
    }

    public class FilterConfigurationResources {
        private List<ErrorPage> errorPages = new ArrayList<ErrorPage>();
        private List<CustomFilter> customFilters = new ArrayList<CustomFilter>();
        private List<Gzip> gzips = new ArrayList<Gzip>();
        private List<ModCluster> modClusters = new ArrayList<ModCluster>();
        private List<ExpressionFilter> expressionFilters = new ArrayList<ExpressionFilter>();
        private List<ResponseHeader> responseHeaders = new ArrayList<ResponseHeader>();
        private List<Rewrite> rewrites = new ArrayList<Rewrite>();
        private List<ConnectionLimit> connectionLimits = new ArrayList<ConnectionLimit>();

        @Subresource
        public List<ErrorPage> errorPages() {
            return this.errorPages;
        }

        @Subresource
        public List<CustomFilter> customFilters() {
            return this.customFilters;
        }

        @Subresource
        public List<Gzip> gzips() {
            return this.gzips;
        }

        @Subresource
        public List<ModCluster> modClusters() {
            return this.modClusters;
        }

        @Subresource
        public List<ExpressionFilter> expressionFilters() {
            return this.expressionFilters;
        }

        @Subresource
        public List<ResponseHeader> responseHeaders() {
            return this.responseHeaders;
        }

        @Subresource
        public List<Rewrite> rewrites() {
            return this.rewrites;
        }

        @Subresource
        public List<ConnectionLimit> connectionLimits() {
            return this.connectionLimits;
        }
    }
}

