/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.server.AJPListener;
import org.wildfly.swarm.config.undertow.server.AJPListenerConfigurator;
import org.wildfly.swarm.config.undertow.server.HTTPListener;
import org.wildfly.swarm.config.undertow.server.HTTPListenerConfigurator;
import org.wildfly.swarm.config.undertow.server.Host;
import org.wildfly.swarm.config.undertow.server.HostConfigurator;
import org.wildfly.swarm.config.undertow.server.HttpsListener;
import org.wildfly.swarm.config.undertow.server.HttpsListenerConfigurator;

@ResourceType(value="server")
public class Server<T extends Server> {
    private String key;
    private String defaultHost;
    private String servletContainer;
    private ServerResources subresources = new ServerResources();

    public Server(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="default-host")
    public String defaultHost() {
        return this.defaultHost;
    }

    public Server defaultHost(String value) {
        this.defaultHost = value;
        return this;
    }

    @ModelNodeBinding(detypedName="servlet-container")
    public String servletContainer() {
        return this.servletContainer;
    }

    public Server servletContainer(String value) {
        this.servletContainer = value;
        return this;
    }

    public ServerResources subresources() {
        return this.subresources;
    }

    public Server hosts(List<Host> value) {
        this.subresources.hosts = value;
        return this;
    }

    public Server host(Host value) {
        this.subresources.hosts.add(value);
        return this;
    }

    public Server host(String childKey, HostConfigurator config) {
        Host child = new Host(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.host(child);
        return this;
    }

    public Server host(String childKey) {
        this.host(childKey, null);
        return this;
    }

    public Server httpListeners(List<HTTPListener> value) {
        this.subresources.httpListeners = value;
        return this;
    }

    public Server httpListener(HTTPListener value) {
        this.subresources.httpListeners.add(value);
        return this;
    }

    public Server httpListener(String childKey, HTTPListenerConfigurator config) {
        HTTPListener child = new HTTPListener(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.httpListener(child);
        return this;
    }

    public Server httpListener(String childKey) {
        this.httpListener(childKey, null);
        return this;
    }

    public Server ajpListeners(List<AJPListener> value) {
        this.subresources.ajpListeners = value;
        return this;
    }

    public Server ajpListener(AJPListener value) {
        this.subresources.ajpListeners.add(value);
        return this;
    }

    public Server ajpListener(String childKey, AJPListenerConfigurator config) {
        AJPListener child = new AJPListener(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.ajpListener(child);
        return this;
    }

    public Server ajpListener(String childKey) {
        this.ajpListener(childKey, null);
        return this;
    }

    public Server httpsListeners(List<HttpsListener> value) {
        this.subresources.httpsListeners = value;
        return this;
    }

    public Server httpsListener(HttpsListener value) {
        this.subresources.httpsListeners.add(value);
        return this;
    }

    public Server httpsListener(String childKey, HttpsListenerConfigurator config) {
        HttpsListener child = new HttpsListener(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.httpsListener(child);
        return this;
    }

    public Server httpsListener(String childKey) {
        this.httpsListener(childKey, null);
        return this;
    }

    public class ServerResources {
        private List<Host> hosts = new ArrayList<Host>();
        private List<HTTPListener> httpListeners = new ArrayList<HTTPListener>();
        private List<AJPListener> ajpListeners = new ArrayList<AJPListener>();
        private List<HttpsListener> httpsListeners = new ArrayList<HttpsListener>();

        @Subresource
        public List<Host> hosts() {
            return this.hosts;
        }

        @Subresource
        public List<HTTPListener> httpListeners() {
            return this.httpListeners;
        }

        @Subresource
        public List<AJPListener> ajpListeners() {
            return this.ajpListeners;
        }

        @Subresource
        public List<HttpsListener> httpsListeners() {
            return this.httpsListeners;
        }
    }
}

