/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.configuration;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.Balancer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.BalancerConfigurator;

@ResourceType(value="mod-cluster")
public class ModCluster<T extends ModCluster> {
    private String key;
    private Integer advertiseFrequency;
    private String advertisePath;
    private String advertiseProtocol;
    private String advertiseSocketBinding;
    private Integer brokenNodeTimeout;
    private Integer cachedConnectionsPerThread;
    private Integer connectionIdleTimeout;
    private Integer connectionsPerThread;
    private Integer healthCheckInterval;
    private String managementAccessPredicate;
    private String managementSocketBinding;
    private Integer maxRequestTime;
    private Integer requestQueueSize;
    private String securityKey;
    private String securityRealm;
    private Boolean useAlias;
    private String worker;
    private ModClusterResources subresources = new ModClusterResources();

    public ModCluster(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="advertise-frequency")
    public Integer advertiseFrequency() {
        return this.advertiseFrequency;
    }

    public ModCluster advertiseFrequency(Integer value) {
        this.advertiseFrequency = value;
        return this;
    }

    @ModelNodeBinding(detypedName="advertise-path")
    public String advertisePath() {
        return this.advertisePath;
    }

    public ModCluster advertisePath(String value) {
        this.advertisePath = value;
        return this;
    }

    @ModelNodeBinding(detypedName="advertise-protocol")
    public String advertiseProtocol() {
        return this.advertiseProtocol;
    }

    public ModCluster advertiseProtocol(String value) {
        this.advertiseProtocol = value;
        return this;
    }

    @ModelNodeBinding(detypedName="advertise-socket-binding")
    public String advertiseSocketBinding() {
        return this.advertiseSocketBinding;
    }

    public ModCluster advertiseSocketBinding(String value) {
        this.advertiseSocketBinding = value;
        return this;
    }

    @ModelNodeBinding(detypedName="broken-node-timeout")
    public Integer brokenNodeTimeout() {
        return this.brokenNodeTimeout;
    }

    public ModCluster brokenNodeTimeout(Integer value) {
        this.brokenNodeTimeout = value;
        return this;
    }

    @ModelNodeBinding(detypedName="cached-connections-per-thread")
    public Integer cachedConnectionsPerThread() {
        return this.cachedConnectionsPerThread;
    }

    public ModCluster cachedConnectionsPerThread(Integer value) {
        this.cachedConnectionsPerThread = value;
        return this;
    }

    @ModelNodeBinding(detypedName="connection-idle-timeout")
    public Integer connectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public ModCluster connectionIdleTimeout(Integer value) {
        this.connectionIdleTimeout = value;
        return this;
    }

    @ModelNodeBinding(detypedName="connections-per-thread")
    public Integer connectionsPerThread() {
        return this.connectionsPerThread;
    }

    public ModCluster connectionsPerThread(Integer value) {
        this.connectionsPerThread = value;
        return this;
    }

    @ModelNodeBinding(detypedName="health-check-interval")
    public Integer healthCheckInterval() {
        return this.healthCheckInterval;
    }

    public ModCluster healthCheckInterval(Integer value) {
        this.healthCheckInterval = value;
        return this;
    }

    @ModelNodeBinding(detypedName="management-access-predicate")
    public String managementAccessPredicate() {
        return this.managementAccessPredicate;
    }

    public ModCluster managementAccessPredicate(String value) {
        this.managementAccessPredicate = value;
        return this;
    }

    @ModelNodeBinding(detypedName="management-socket-binding")
    public String managementSocketBinding() {
        return this.managementSocketBinding;
    }

    public ModCluster managementSocketBinding(String value) {
        this.managementSocketBinding = value;
        return this;
    }

    @ModelNodeBinding(detypedName="max-request-time")
    public Integer maxRequestTime() {
        return this.maxRequestTime;
    }

    public ModCluster maxRequestTime(Integer value) {
        this.maxRequestTime = value;
        return this;
    }

    @ModelNodeBinding(detypedName="request-queue-size")
    public Integer requestQueueSize() {
        return this.requestQueueSize;
    }

    public ModCluster requestQueueSize(Integer value) {
        this.requestQueueSize = value;
        return this;
    }

    @ModelNodeBinding(detypedName="security-key")
    public String securityKey() {
        return this.securityKey;
    }

    public ModCluster securityKey(String value) {
        this.securityKey = value;
        return this;
    }

    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    public ModCluster securityRealm(String value) {
        this.securityRealm = value;
        return this;
    }

    @ModelNodeBinding(detypedName="use-alias")
    public Boolean useAlias() {
        return this.useAlias;
    }

    public ModCluster useAlias(Boolean value) {
        this.useAlias = value;
        return this;
    }

    @ModelNodeBinding(detypedName="worker")
    public String worker() {
        return this.worker;
    }

    public ModCluster worker(String value) {
        this.worker = value;
        return this;
    }

    public ModClusterResources subresources() {
        return this.subresources;
    }

    public ModCluster balancers(List<Balancer> value) {
        this.subresources.balancers = value;
        return this;
    }

    public ModCluster balancer(Balancer value) {
        this.subresources.balancers.add(value);
        return this;
    }

    public ModCluster balancer(String childKey, BalancerConfigurator config) {
        Balancer child = new Balancer(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.balancer(child);
        return this;
    }

    public ModCluster balancer(String childKey) {
        this.balancer(childKey, null);
        return this;
    }

    public class ModClusterResources {
        private List<Balancer> balancers = new ArrayList<Balancer>();

        @Subresource
        public List<Balancer> balancers() {
            return this.balancers;
        }
    }
}

