package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.datasources.JDBCDriver;
import org.wildfly.swarm.config.datasources.JDBCDriverConfigurator;
import org.wildfly.swarm.config.datasources.XADataSource;
import org.wildfly.swarm.config.datasources.XADataSourceConfigurator;
import org.wildfly.swarm.config.datasources.DataSource;
import org.wildfly.swarm.config.datasources.DataSourceConfigurator;
/**
 * The data-sources subsystem, used to declare JDBC data-sources
 */
@ResourceType("subsystem")
@Implicit
public class Datasources<T extends Datasources> {

	private String key;
	private List<java.util.Map> installedDrivers;
	private DatasourcesResources subresources = new DatasourcesResources();

	public Datasources() {
		this.key = "datasources";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * List of JDBC drivers that have been installed in the runtime
	 */
	@ModelNodeBinding(detypedName = "installed-drivers")
	public List<Map> installedDrivers() {
		return this.installedDrivers;
	}

	/**
	 * List of JDBC drivers that have been installed in the runtime
	 */
	@SuppressWarnings("unchecked")
	public T installedDrivers(List<java.util.Map> value) {
		this.installedDrivers = value;
		return (T) this;
	}

	/**
	 * List of JDBC drivers that have been installed in the runtime
	 */
	public T installedDriver(Map value) {
		if (this.installedDrivers == null) {
			this.installedDrivers = new java.util.ArrayList<>();
		}
		this.installedDrivers.add(value);
		return (T) this;
	}

	public DatasourcesResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.datasources.JDBCDriver objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.datasources.JDBCDriver objects.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcDrivers(
			List<org.wildfly.swarm.config.datasources.JDBCDriver> value) {
		this.subresources.jdbcDrivers = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.datasources.JDBCDriver object to the list of subresources
	 * @param value The org.wildfly.swarm.config.datasources.JDBCDriver to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jdbcDriver(JDBCDriver value) {
		this.subresources.jdbcDrivers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.datasources.JDBCDriver object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.datasources.JDBCDriver resource
	 * @param config The org.wildfly.swarm.config.datasources.JDBCDriverConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jdbcDriver(String childKey, JDBCDriverConfigurator config) {
		org.wildfly.swarm.config.datasources.JDBCDriver child = new org.wildfly.swarm.config.datasources.JDBCDriver(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		jdbcDriver(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.datasources.JDBCDriver object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.datasources.JDBCDriver resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jdbcDriver(String childKey) {
		jdbcDriver(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.datasources.XADataSource objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.datasources.XADataSource objects.
	 */
	@SuppressWarnings("unchecked")
	public T xaDataSources(
			List<org.wildfly.swarm.config.datasources.XADataSource> value) {
		this.subresources.xaDataSources = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.datasources.XADataSource object to the list of subresources
	 * @param value The org.wildfly.swarm.config.datasources.XADataSource to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T xaDataSource(XADataSource value) {
		this.subresources.xaDataSources.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.datasources.XADataSource object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.datasources.XADataSource resource
	 * @param config The org.wildfly.swarm.config.datasources.XADataSourceConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T xaDataSource(String childKey, XADataSourceConfigurator config) {
		org.wildfly.swarm.config.datasources.XADataSource child = new org.wildfly.swarm.config.datasources.XADataSource(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		xaDataSource(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.datasources.XADataSource object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.datasources.XADataSource resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T xaDataSource(String childKey) {
		xaDataSource(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.datasources.DataSource objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.datasources.DataSource objects.
	 */
	@SuppressWarnings("unchecked")
	public T dataSources(
			List<org.wildfly.swarm.config.datasources.DataSource> value) {
		this.subresources.dataSources = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.datasources.DataSource object to the list of subresources
	 * @param value The org.wildfly.swarm.config.datasources.DataSource to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T dataSource(DataSource value) {
		this.subresources.dataSources.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.datasources.DataSource object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.datasources.DataSource resource
	 * @param config The org.wildfly.swarm.config.datasources.DataSourceConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T dataSource(String childKey, DataSourceConfigurator config) {
		org.wildfly.swarm.config.datasources.DataSource child = new org.wildfly.swarm.config.datasources.DataSource(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		dataSource(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.datasources.DataSource object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.datasources.DataSource resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T dataSource(String childKey) {
		dataSource(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for Datasources
	 */
	public class DatasourcesResources {
		/**
		 * Service that make a JDBC driver available for use in the runtime
		 */
		private List<org.wildfly.swarm.config.datasources.JDBCDriver> jdbcDrivers = new java.util.ArrayList<>();
		/**
		 * A JDBC XA data-source configuration
		 */
		private List<org.wildfly.swarm.config.datasources.XADataSource> xaDataSources = new java.util.ArrayList<>();
		/**
		 * A JDBC data-source configuration
		 */
		private List<org.wildfly.swarm.config.datasources.DataSource> dataSources = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.datasources.JDBCDriver resources
		 * @return the list of resources
		 */
		@Subresource
		public List<JDBCDriver> jdbcDrivers() {
			return this.jdbcDrivers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.datasources.XADataSource resources
		 * @return the list of resources
		 */
		@Subresource
		public List<XADataSource> xaDataSources() {
			return this.xaDataSources;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.datasources.DataSource resources
		 * @return the list of resources
		 */
		@Subresource
		public List<DataSource> dataSources() {
			return this.dataSources;
		}
	}
}