package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.ee.ManagedThreadFactory;
import org.wildfly.swarm.config.ee.ManagedThreadFactoryConfigurator;
import org.wildfly.swarm.config.ee.ContextService;
import org.wildfly.swarm.config.ee.ContextServiceConfigurator;
import org.wildfly.swarm.config.ee.ManagedExecutorService;
import org.wildfly.swarm.config.ee.ManagedExecutorServiceConfigurator;
import org.wildfly.swarm.config.ee.ManagedScheduledExecutorService;
import org.wildfly.swarm.config.ee.ManagedScheduledExecutorServiceConfigurator;
import org.wildfly.swarm.config.ee.DefaultBindingsService;
/**
 * The configuration of the EE subsystem.
 */
@ResourceType("subsystem")
@Implicit
public class EE<T extends EE> {

	private String key;
	private Boolean annotationPropertyReplacement;
	private Boolean earSubdeploymentsIsolated;
	private List<java.util.Map> globalModules;
	private Boolean jbossDescriptorPropertyReplacement;
	private Boolean specDescriptorPropertyReplacement;
	private EEResources subresources = new EEResources();
	private DefaultBindingsService defaultBindingsService;

	public EE() {
		this.key = "ee";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Flag indicating whether Java EE annotations will have property replacements applied
	 */
	@ModelNodeBinding(detypedName = "annotation-property-replacement")
	public Boolean annotationPropertyReplacement() {
		return this.annotationPropertyReplacement;
	}

	/**
	 * Flag indicating whether Java EE annotations will have property replacements applied
	 */
	@SuppressWarnings("unchecked")
	public T annotationPropertyReplacement(Boolean value) {
		this.annotationPropertyReplacement = value;
		return (T) this;
	}

	/**
	 * Flag indicating whether each of the subdeployments within a .ear can access classes belonging to another subdeployment within the same .ear. A value of false means the subdeployments can see classes belonging to other subdeployments within the .ear.
	 */
	@ModelNodeBinding(detypedName = "ear-subdeployments-isolated")
	public Boolean earSubdeploymentsIsolated() {
		return this.earSubdeploymentsIsolated;
	}

	/**
	 * Flag indicating whether each of the subdeployments within a .ear can access classes belonging to another subdeployment within the same .ear. A value of false means the subdeployments can see classes belonging to other subdeployments within the .ear.
	 */
	@SuppressWarnings("unchecked")
	public T earSubdeploymentsIsolated(Boolean value) {
		this.earSubdeploymentsIsolated = value;
		return (T) this;
	}

	/**
	 * A list of modules that should be made available to all deployments.
	 */
	@ModelNodeBinding(detypedName = "global-modules")
	public List<Map> globalModules() {
		return this.globalModules;
	}

	/**
	 * A list of modules that should be made available to all deployments.
	 */
	@SuppressWarnings("unchecked")
	public T globalModules(List<java.util.Map> value) {
		this.globalModules = value;
		return (T) this;
	}

	/**
	 * A list of modules that should be made available to all deployments.
	 */
	public T globalModule(Map value) {
		if (this.globalModules == null) {
			this.globalModules = new java.util.ArrayList<>();
		}
		this.globalModules.add(value);
		return (T) this;
	}

	/**
	 * Flag indicating whether JBoss specific deployment descriptors will have property replacements applied
	 */
	@ModelNodeBinding(detypedName = "jboss-descriptor-property-replacement")
	public Boolean jbossDescriptorPropertyReplacement() {
		return this.jbossDescriptorPropertyReplacement;
	}

	/**
	 * Flag indicating whether JBoss specific deployment descriptors will have property replacements applied
	 */
	@SuppressWarnings("unchecked")
	public T jbossDescriptorPropertyReplacement(Boolean value) {
		this.jbossDescriptorPropertyReplacement = value;
		return (T) this;
	}

	/**
	 * Flag indicating whether descriptors defined by the Java EE specification will have property replacements applied
	 */
	@ModelNodeBinding(detypedName = "spec-descriptor-property-replacement")
	public Boolean specDescriptorPropertyReplacement() {
		return this.specDescriptorPropertyReplacement;
	}

	/**
	 * Flag indicating whether descriptors defined by the Java EE specification will have property replacements applied
	 */
	@SuppressWarnings("unchecked")
	public T specDescriptorPropertyReplacement(Boolean value) {
		this.specDescriptorPropertyReplacement = value;
		return (T) this;
	}

	public EEResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.ee.ManagedThreadFactory objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.ee.ManagedThreadFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T managedThreadFactorys(
			List<org.wildfly.swarm.config.ee.ManagedThreadFactory> value) {
		this.subresources.managedThreadFactorys = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.ee.ManagedThreadFactory object to the list of subresources
	 * @param value The org.wildfly.swarm.config.ee.ManagedThreadFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedThreadFactory(ManagedThreadFactory value) {
		this.subresources.managedThreadFactorys.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ee.ManagedThreadFactory object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ee.ManagedThreadFactory resource
	 * @param config The org.wildfly.swarm.config.ee.ManagedThreadFactoryConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedThreadFactory(String childKey,
			ManagedThreadFactoryConfigurator config) {
		org.wildfly.swarm.config.ee.ManagedThreadFactory child = new org.wildfly.swarm.config.ee.ManagedThreadFactory(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		managedThreadFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ee.ManagedThreadFactory object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ee.ManagedThreadFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedThreadFactory(String childKey) {
		managedThreadFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.ee.ContextService objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.ee.ContextService objects.
	 */
	@SuppressWarnings("unchecked")
	public T contextServices(
			List<org.wildfly.swarm.config.ee.ContextService> value) {
		this.subresources.contextServices = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.ee.ContextService object to the list of subresources
	 * @param value The org.wildfly.swarm.config.ee.ContextService to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T contextService(ContextService value) {
		this.subresources.contextServices.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ee.ContextService object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ee.ContextService resource
	 * @param config The org.wildfly.swarm.config.ee.ContextServiceConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T contextService(String childKey, ContextServiceConfigurator config) {
		org.wildfly.swarm.config.ee.ContextService child = new org.wildfly.swarm.config.ee.ContextService(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		contextService(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ee.ContextService object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ee.ContextService resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T contextService(String childKey) {
		contextService(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.ee.ManagedExecutorService objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.ee.ManagedExecutorService objects.
	 */
	@SuppressWarnings("unchecked")
	public T managedExecutorServices(
			List<org.wildfly.swarm.config.ee.ManagedExecutorService> value) {
		this.subresources.managedExecutorServices = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.ee.ManagedExecutorService object to the list of subresources
	 * @param value The org.wildfly.swarm.config.ee.ManagedExecutorService to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedExecutorService(ManagedExecutorService value) {
		this.subresources.managedExecutorServices.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ee.ManagedExecutorService object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ee.ManagedExecutorService resource
	 * @param config The org.wildfly.swarm.config.ee.ManagedExecutorServiceConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedExecutorService(String childKey,
			ManagedExecutorServiceConfigurator config) {
		org.wildfly.swarm.config.ee.ManagedExecutorService child = new org.wildfly.swarm.config.ee.ManagedExecutorService(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		managedExecutorService(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ee.ManagedExecutorService object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ee.ManagedExecutorService resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedExecutorService(String childKey) {
		managedExecutorService(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.ee.ManagedScheduledExecutorService objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.ee.ManagedScheduledExecutorService objects.
	 */
	@SuppressWarnings("unchecked")
	public T managedScheduledExecutorServices(
			List<org.wildfly.swarm.config.ee.ManagedScheduledExecutorService> value) {
		this.subresources.managedScheduledExecutorServices = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.ee.ManagedScheduledExecutorService object to the list of subresources
	 * @param value The org.wildfly.swarm.config.ee.ManagedScheduledExecutorService to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedScheduledExecutorService(
			ManagedScheduledExecutorService value) {
		this.subresources.managedScheduledExecutorServices.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ee.ManagedScheduledExecutorService object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ee.ManagedScheduledExecutorService resource
	 * @param config The org.wildfly.swarm.config.ee.ManagedScheduledExecutorServiceConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedScheduledExecutorService(String childKey,
			ManagedScheduledExecutorServiceConfigurator config) {
		org.wildfly.swarm.config.ee.ManagedScheduledExecutorService child = new org.wildfly.swarm.config.ee.ManagedScheduledExecutorService(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		managedScheduledExecutorService(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.ee.ManagedScheduledExecutorService object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.ee.ManagedScheduledExecutorService resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T managedScheduledExecutorService(String childKey) {
		managedScheduledExecutorService(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for EE
	 */
	public class EEResources {
		/**
		 * A managed thread factory
		 */
		private List<org.wildfly.swarm.config.ee.ManagedThreadFactory> managedThreadFactorys = new java.util.ArrayList<>();
		/**
		 * A context service
		 */
		private List<org.wildfly.swarm.config.ee.ContextService> contextServices = new java.util.ArrayList<>();
		/**
		 * A managed executor service
		 */
		private List<org.wildfly.swarm.config.ee.ManagedExecutorService> managedExecutorServices = new java.util.ArrayList<>();
		/**
		 * A managed scheduled executor service
		 */
		private List<org.wildfly.swarm.config.ee.ManagedScheduledExecutorService> managedScheduledExecutorServices = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.ee.ManagedThreadFactory resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ManagedThreadFactory> managedThreadFactorys() {
			return this.managedThreadFactorys;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.ee.ContextService resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ContextService> contextServices() {
			return this.contextServices;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.ee.ManagedExecutorService resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ManagedExecutorService> managedExecutorServices() {
			return this.managedExecutorServices;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.ee.ManagedScheduledExecutorService resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ManagedScheduledExecutorService> managedScheduledExecutorServices() {
			return this.managedScheduledExecutorServices;
		}
	}

	/**
	 * The JNDI names for the default EE bindings
	 */
	@Subresource
	public DefaultBindingsService defaultBindingsService() {
		return this.defaultBindingsService;
	}

	/**
	 * The JNDI names for the default EE bindings
	 */
	@SuppressWarnings("unchecked")
	public T defaultBindingsService(DefaultBindingsService value) {
		this.defaultBindingsService = value;
		return (T) this;
	}
}