package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.mail.MailSession;
import org.wildfly.swarm.config.mail.MailSessionConfigurator;
/**
 * The mail subsystem
 */
@ResourceType("subsystem")
@Implicit
public class Mail<T extends Mail> {

	private String key;
	private MailResources subresources = new MailResources();

	public Mail() {
		this.key = "mail";
	}

	public String getKey() {
		return this.key;
	}

	public MailResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.mail.MailSession objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.mail.MailSession objects.
	 */
	@SuppressWarnings("unchecked")
	public T mailSessions(List<org.wildfly.swarm.config.mail.MailSession> value) {
		this.subresources.mailSessions = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.mail.MailSession object to the list of subresources
	 * @param value The org.wildfly.swarm.config.mail.MailSession to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mailSession(MailSession value) {
		this.subresources.mailSessions.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.mail.MailSession object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.mail.MailSession resource
	 * @param config The org.wildfly.swarm.config.mail.MailSessionConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mailSession(String childKey, MailSessionConfigurator config) {
		org.wildfly.swarm.config.mail.MailSession child = new org.wildfly.swarm.config.mail.MailSession(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		mailSession(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.mail.MailSession object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.mail.MailSession resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mailSession(String childKey) {
		mailSession(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for Mail
	 */
	public class MailResources {
		/**
		 * Mail session definition
		 */
		private List<org.wildfly.swarm.config.mail.MailSession> mailSessions = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.mail.MailSession resources
		 * @return the list of resources
		 */
		@Subresource
		public List<MailSession> mailSessions() {
			return this.mailSessions;
		}
	}
}