package org.wildfly.swarm.config.ee;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The JNDI names for the default EE bindings
 */
@ResourceType("service")
@Implicit
public class DefaultBindingsService<T extends DefaultBindingsService> {

	private String key;
	private String contextService;
	private String datasource;
	private String jmsConnectionFactory;
	private String managedExecutorService;
	private String managedScheduledExecutorService;
	private String managedThreadFactory;

	public DefaultBindingsService() {
		this.key = "default-bindings";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The JNDI name where the default EE Context Service can be found
	 */
	@ModelNodeBinding(detypedName = "context-service")
	public String contextService() {
		return this.contextService;
	}

	/**
	 * The JNDI name where the default EE Context Service can be found
	 */
	@SuppressWarnings("unchecked")
	public T contextService(String value) {
		this.contextService = value;
		return (T) this;
	}

	/**
	 * The JNDI name where the default EE Datasource can be found
	 */
	@ModelNodeBinding(detypedName = "datasource")
	public String datasource() {
		return this.datasource;
	}

	/**
	 * The JNDI name where the default EE Datasource can be found
	 */
	@SuppressWarnings("unchecked")
	public T datasource(String value) {
		this.datasource = value;
		return (T) this;
	}

	/**
	 * The JNDI name where the default EE JMS Connection Factory can be found
	 */
	@ModelNodeBinding(detypedName = "jms-connection-factory")
	public String jmsConnectionFactory() {
		return this.jmsConnectionFactory;
	}

	/**
	 * The JNDI name where the default EE JMS Connection Factory can be found
	 */
	@SuppressWarnings("unchecked")
	public T jmsConnectionFactory(String value) {
		this.jmsConnectionFactory = value;
		return (T) this;
	}

	/**
	 * The JNDI name where the default EE Managed Executor Service can be found
	 */
	@ModelNodeBinding(detypedName = "managed-executor-service")
	public String managedExecutorService() {
		return this.managedExecutorService;
	}

	/**
	 * The JNDI name where the default EE Managed Executor Service can be found
	 */
	@SuppressWarnings("unchecked")
	public T managedExecutorService(String value) {
		this.managedExecutorService = value;
		return (T) this;
	}

	/**
	 * The JNDI name where the default EE Managed Scheduled Executor Service can be found
	 */
	@ModelNodeBinding(detypedName = "managed-scheduled-executor-service")
	public String managedScheduledExecutorService() {
		return this.managedScheduledExecutorService;
	}

	/**
	 * The JNDI name where the default EE Managed Scheduled Executor Service can be found
	 */
	@SuppressWarnings("unchecked")
	public T managedScheduledExecutorService(String value) {
		this.managedScheduledExecutorService = value;
		return (T) this;
	}

	/**
	 * The JNDI name where the default EE Managed Thread Factory can be found
	 */
	@ModelNodeBinding(detypedName = "managed-thread-factory")
	public String managedThreadFactory() {
		return this.managedThreadFactory;
	}

	/**
	 * The JNDI name where the default EE Managed Thread Factory can be found
	 */
	@SuppressWarnings("unchecked")
	public T managedThreadFactory(String value) {
		this.managedThreadFactory = value;
		return (T) this;
	}
}