package org.wildfly.swarm.config.ejb3.service;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A JVM local file store that stores persistent EJB timers
 */
@ResourceType("file-data-store")
public class FileDataStore<T extends FileDataStore> {

	private String key;
	private String path;
	private String relativeTo;

	public FileDataStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The directory to store persistent timer information in
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * The directory to store persistent timer information in
	 */
	@SuppressWarnings("unchecked")
	public T path(String value) {
		this.path = value;
		return (T) this;
	}

	/**
	 * The relative path that is used to resolve the timer data store location
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The relative path that is used to resolve the timer data store location
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(String value) {
		this.relativeTo = value;
		return (T) this;
	}
}