package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A backup site to which to replicate this cache.
 */
@ResourceType("backup")
public class Backup<T extends Backup> {

	private String key;
	private Integer afterFailures;
	private Boolean enabled;
	private String failurePolicy;
	private Long minWait;
	private String strategy;
	private Long timeout;

	public Backup(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Indicates the number of failures after which this backup site should go offline.
	 */
	@ModelNodeBinding(detypedName = "after-failures")
	public Integer afterFailures() {
		return this.afterFailures;
	}

	/**
	 * Indicates the number of failures after which this backup site should go offline.
	 */
	@SuppressWarnings("unchecked")
	public T afterFailures(Integer value) {
		this.afterFailures = value;
		return (T) this;
	}

	/**
	 * Indicates whether or not this backup site is enabled.
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Indicates whether or not this backup site is enabled.
	 */
	@SuppressWarnings("unchecked")
	public T enabled(Boolean value) {
		this.enabled = value;
		return (T) this;
	}

	/**
	 * The policy to follow when connectivity to the backup site fails.
	 */
	@ModelNodeBinding(detypedName = "failure-policy")
	public String failurePolicy() {
		return this.failurePolicy;
	}

	/**
	 * The policy to follow when connectivity to the backup site fails.
	 */
	@SuppressWarnings("unchecked")
	public T failurePolicy(String value) {
		this.failurePolicy = value;
		return (T) this;
	}

	/**
	 * Indicates the minimum time (in milliseconds) to wait after the max number of failures is reached, after which this backup site should go offline.
	 */
	@ModelNodeBinding(detypedName = "min-wait")
	public Long minWait() {
		return this.minWait;
	}

	/**
	 * Indicates the minimum time (in milliseconds) to wait after the max number of failures is reached, after which this backup site should go offline.
	 */
	@SuppressWarnings("unchecked")
	public T minWait(Long value) {
		this.minWait = value;
		return (T) this;
	}

	/**
	 * The backup strategy for this cache
	 */
	@ModelNodeBinding(detypedName = "strategy")
	public String strategy() {
		return this.strategy;
	}

	/**
	 * The backup strategy for this cache
	 */
	@SuppressWarnings("unchecked")
	public T strategy(String value) {
		this.strategy = value;
		return (T) this;
	}

	/**
	 * The timeout for replicating to the backup site.
	 */
	@ModelNodeBinding(detypedName = "timeout")
	public Long timeout() {
		return this.timeout;
	}

	/**
	 * The timeout for replicating to the backup site.
	 */
	@SuppressWarnings("unchecked")
	public T timeout(Long value) {
		this.timeout = value;
		return (T) this;
	}
}