package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The description of the transport used by this cache container
 */
@ResourceType("transport")
@Implicit
public class JGroupsTransport<T extends JGroupsTransport> {

	private String key;
	private String channel;
	private Long lockTimeout;

	public JGroupsTransport() {
		this.key = "jgroups";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The channel of this cache container's transport.
	 */
	@ModelNodeBinding(detypedName = "channel")
	public String channel() {
		return this.channel;
	}

	/**
	 * The channel of this cache container's transport.
	 */
	@SuppressWarnings("unchecked")
	public T channel(String value) {
		this.channel = value;
		return (T) this;
	}

	/**
	 * The timeout for locks for the transport
	 */
	@ModelNodeBinding(detypedName = "lock-timeout")
	public Long lockTimeout() {
		return this.lockTimeout;
	}

	/**
	 * The timeout for locks for the transport
	 */
	@SuppressWarnings("unchecked")
	public T lockTimeout(Long value) {
		this.lockTimeout = value;
		return (T) this;
	}
}