package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.Subresource;
/**
 * A local cache configuration
 */
@ResourceType("local-cache")
public class LocalCache<T extends LocalCache> {

	private String key;
	private Long activations;
	private Long averageReadTime;
	private Long averageWriteTime;
	private String cacheStatus;
	private Long elapsedTime;
	private Double hitRatio;
	private Long hits;
	private Long invalidations;
	private String jndiName;
	private Long misses;
	private String module;
	private Integer numberOfEntries;
	private Long passivations;
	private Double readWriteRatio;
	private Long removeHits;
	private Long removeMisses;
	private Boolean statisticsEnabled;
	private Long stores;
	private Long timeSinceReset;
	private EvictionComponent evictionComponent;
	private StringJDBCStore stringJdbcStore;
	private CustomStore customStore;
	private ExpirationComponent expirationComponent;
	private FileStore fileStore;
	private NoneStore noneStore;
	private TransactionComponent transactionComponent;
	private LockingComponent lockingComponent;
	private BinaryJDBCStore binaryJdbcStore;
	private MixedJDBCStore mixedJdbcStore;
	private RemoteStore remoteStore;

	public LocalCache(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a cache store) . May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "activations")
	public Long activations() {
		return this.activations;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a cache store) . May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T activations(Long value) {
		this.activations = value;
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-read-time")
	public Long averageReadTime() {
		return this.averageReadTime;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageReadTime(Long value) {
		this.averageReadTime = value;
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-write-time")
	public Long averageWriteTime() {
		return this.averageWriteTime;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageWriteTime(Long value) {
		this.averageWriteTime = value;
		return (T) this;
	}

	/**
	 * The status of the cache component. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "cache-status")
	public String cacheStatus() {
		return this.cacheStatus;
	}

	/**
	 * The status of the cache component. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T cacheStatus(String value) {
		this.cacheStatus = value;
		return (T) this;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "elapsed-time")
	public Long elapsedTime() {
		return this.elapsedTime;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T elapsedTime(Long value) {
		this.elapsedTime = value;
		return (T) this;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hit-ratio")
	public Double hitRatio() {
		return this.hitRatio;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T hitRatio(Double value) {
		this.hitRatio = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hits")
	public Long hits() {
		return this.hits;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T hits(Long value) {
		this.hits = value;
		return (T) this;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "invalidations")
	public Long invalidations() {
		return this.invalidations;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T invalidations(Long value) {
		this.invalidations = value;
		return (T) this;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		this.jndiName = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "misses")
	public Long misses() {
		return this.misses;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T misses(Long value) {
		this.misses = value;
		return (T) this;
	}

	/**
	 * The module whose class loader should be used when building this cache's configuration.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module whose class loader should be used when building this cache's configuration.
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		this.module = value;
		return (T) this;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "number-of-entries")
	public Integer numberOfEntries() {
		return this.numberOfEntries;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfEntries(Integer value) {
		this.numberOfEntries = value;
		return (T) this;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to a cache store). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "passivations")
	public Long passivations() {
		return this.passivations;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to a cache store). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T passivations(Long value) {
		this.passivations = value;
		return (T) this;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "read-write-ratio")
	public Double readWriteRatio() {
		return this.readWriteRatio;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T readWriteRatio(Double value) {
		this.readWriteRatio = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-hits")
	public Long removeHits() {
		return this.removeHits;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T removeHits(Long value) {
		this.removeHits = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-misses")
	public Long removeMisses() {
		return this.removeMisses;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T removeMisses(Long value) {
		this.removeMisses = value;
		return (T) this;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(Boolean value) {
		this.statisticsEnabled = value;
		return (T) this;
	}

	/**
	 * The number of cache attribute put operations. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "stores")
	public Long stores() {
		return this.stores;
	}

	/**
	 * The number of cache attribute put operations. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T stores(Long value) {
		this.stores = value;
		return (T) this;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "time-since-reset")
	public Long timeSinceReset() {
		return this.timeSinceReset;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T timeSinceReset(Long value) {
		this.timeSinceReset = value;
		return (T) this;
	}

	/**
	 * The cache eviction configuration.
	 */
	@Subresource
	public EvictionComponent evictionComponent() {
		return this.evictionComponent;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T evictionComponent(EvictionComponent value) {
		this.evictionComponent = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public StringJDBCStore stringJdbcStore() {
		return this.stringJdbcStore;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T stringJdbcStore(StringJDBCStore value) {
		this.stringJdbcStore = value;
		return (T) this;
	}

	/**
	 * The cache store configuration.
	 */
	@Subresource
	public CustomStore customStore() {
		return this.customStore;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T customStore(CustomStore value) {
		this.customStore = value;
		return (T) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@Subresource
	public ExpirationComponent expirationComponent() {
		return this.expirationComponent;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public T expirationComponent(ExpirationComponent value) {
		this.expirationComponent = value;
		return (T) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@Subresource
	public FileStore fileStore() {
		return this.fileStore;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T fileStore(FileStore value) {
		this.fileStore = value;
		return (T) this;
	}

	/**
	 * A store-less configuration.
	 */
	@Subresource
	public NoneStore noneStore() {
		return this.noneStore;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public T noneStore(NoneStore value) {
		this.noneStore = value;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@Subresource
	public TransactionComponent transactionComponent() {
		return this.transactionComponent;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponent value) {
		this.transactionComponent = value;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@Subresource
	public LockingComponent lockingComponent() {
		return this.lockingComponent;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent(LockingComponent value) {
		this.lockingComponent = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public BinaryJDBCStore binaryJdbcStore() {
		return this.binaryJdbcStore;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T binaryJdbcStore(BinaryJDBCStore value) {
		this.binaryJdbcStore = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public MixedJDBCStore mixedJdbcStore() {
		return this.mixedJdbcStore;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T mixedJdbcStore(MixedJDBCStore value) {
		this.mixedJdbcStore = value;
		return (T) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@Subresource
	public RemoteStore remoteStore() {
		return this.remoteStore;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T remoteStore(RemoteStore value) {
		this.remoteStore = value;
		return (T) this;
	}
}