package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The cache transaction configuration.
 */
@ResourceType("component")
@Implicit
public class TransactionComponent<T extends TransactionComponent> {

	private String key;
	private Long commits;
	private String locking;
	private String mode;
	private Long prepares;
	private Long rollbacks;
	private Long stopTimeout;

	public TransactionComponent() {
		this.key = "transaction";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of transaction commits. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "commits")
	public Long commits() {
		return this.commits;
	}

	/**
	 * The number of transaction commits. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T commits(Long value) {
		this.commits = value;
		return (T) this;
	}

	/**
	 * The locking mode for this cache, one of OPTIMISTIC or PESSIMISTIC.
	 */
	@ModelNodeBinding(detypedName = "locking")
	public String locking() {
		return this.locking;
	}

	/**
	 * The locking mode for this cache, one of OPTIMISTIC or PESSIMISTIC.
	 */
	@SuppressWarnings("unchecked")
	public T locking(String value) {
		this.locking = value;
		return (T) this;
	}

	/**
	 * Sets the cache transaction mode to one of NONE, NON_XA, NON_DURABLE_XA, FULL_XA.
	 */
	@ModelNodeBinding(detypedName = "mode")
	public String mode() {
		return this.mode;
	}

	/**
	 * Sets the cache transaction mode to one of NONE, NON_XA, NON_DURABLE_XA, FULL_XA.
	 */
	@SuppressWarnings("unchecked")
	public T mode(String value) {
		this.mode = value;
		return (T) this;
	}

	/**
	 * The number of transaction prepares. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "prepares")
	public Long prepares() {
		return this.prepares;
	}

	/**
	 * The number of transaction prepares. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T prepares(Long value) {
		this.prepares = value;
		return (T) this;
	}

	/**
	 * The number of transaction rollbacks. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "rollbacks")
	public Long rollbacks() {
		return this.rollbacks;
	}

	/**
	 * The number of transaction rollbacks. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T rollbacks(Long value) {
		this.rollbacks = value;
		return (T) this;
	}

	/**
	 * If there are any ongoing transactions when a cache is stopped, Infinispan waits for ongoing remote and local transactions to finish. The amount of time to wait for is defined by the cache stop timeout.
	 */
	@ModelNodeBinding(detypedName = "stop-timeout")
	public Long stopTimeout() {
		return this.stopTimeout;
	}

	/**
	 * If there are any ongoing transactions when a cache is stopped, Infinispan waits for ongoing remote and local transactions to finish. The amount of time to wait for is defined by the cache stop timeout.
	 */
	@SuppressWarnings("unchecked")
	public T stopTimeout(Long value) {
		this.stopTimeout = value;
		return (T) this;
	}
}