package org.wildfly.swarm.config.io;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Defines buffer pool
 */
@ResourceType("buffer-pool")
public class BufferPool<T extends BufferPool> {

	private String key;
	private Integer bufferSize;
	private Integer buffersPerSlice;
	private Boolean directBuffers;

	public BufferPool(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The size of each buffer slice in bytes, if not set optimal value is calculated based on available RAM resources in your system.
	 */
	@ModelNodeBinding(detypedName = "buffer-size")
	public Integer bufferSize() {
		return this.bufferSize;
	}

	/**
	 * The size of each buffer slice in bytes, if not set optimal value is calculated based on available RAM resources in your system.
	 */
	@SuppressWarnings("unchecked")
	public T bufferSize(Integer value) {
		this.bufferSize = value;
		return (T) this;
	}

	/**
	 * How many buffers per slice, if not set optimal value is calculated based on available RAM resources in your system.
	 */
	@ModelNodeBinding(detypedName = "buffers-per-slice")
	public Integer buffersPerSlice() {
		return this.buffersPerSlice;
	}

	/**
	 * How many buffers per slice, if not set optimal value is calculated based on available RAM resources in your system.
	 */
	@SuppressWarnings("unchecked")
	public T buffersPerSlice(Integer value) {
		this.buffersPerSlice = value;
		return (T) this;
	}

	/**
	 * Does the buffer pool use direct buffers, some platforms don't support direct buffers
	 */
	@ModelNodeBinding(detypedName = "direct-buffers")
	public Boolean directBuffers() {
		return this.directBuffers;
	}

	/**
	 * Does the buffer pool use direct buffers, some platforms don't support direct buffers
	 */
	@SuppressWarnings("unchecked")
	public T directBuffers(Boolean value) {
		this.directBuffers = value;
		return (T) this;
	}
}