package org.wildfly.swarm.config.io;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Defines workers
 */
@ResourceType("worker")
public class Worker<T extends Worker> {

	private String key;
	private Integer ioThreads;
	private Long stackSize;
	private Integer taskKeepalive;
	private Integer taskMaxThreads;

	public Worker(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * "Specify the number of I/O threads to create for the worker.  If not specified, a default will be chosen, which is calculated by cpuCount * 2"
	 */
	@ModelNodeBinding(detypedName = "io-threads")
	public Integer ioThreads() {
		return this.ioThreads;
	}

	/**
	 * "Specify the number of I/O threads to create for the worker.  If not specified, a default will be chosen, which is calculated by cpuCount * 2"
	 */
	@SuppressWarnings("unchecked")
	public T ioThreads(Integer value) {
		this.ioThreads = value;
		return (T) this;
	}

	/**
	 * The stack size (in bytes) to attempt to use for worker threads.
	 */
	@ModelNodeBinding(detypedName = "stack-size")
	public Long stackSize() {
		return this.stackSize;
	}

	/**
	 * The stack size (in bytes) to attempt to use for worker threads.
	 */
	@SuppressWarnings("unchecked")
	public T stackSize(Long value) {
		this.stackSize = value;
		return (T) this;
	}

	/**
	 * Specify the number of milliseconds to keep non-core task threads alive.
	 */
	@ModelNodeBinding(detypedName = "task-keepalive")
	public Integer taskKeepalive() {
		return this.taskKeepalive;
	}

	/**
	 * Specify the number of milliseconds to keep non-core task threads alive.
	 */
	@SuppressWarnings("unchecked")
	public T taskKeepalive(Integer value) {
		this.taskKeepalive = value;
		return (T) this;
	}

	/**
	 * "Specify the maximum number of threads for the worker task thread pool.If not set, default value used which is calculated by formula cpuCount * 16"
	 */
	@ModelNodeBinding(detypedName = "task-max-threads")
	public Integer taskMaxThreads() {
		return this.taskMaxThreads;
	}

	/**
	 * "Specify the maximum number of threads for the worker task thread pool.If not set, default value used which is calculated by formula cpuCount * 16"
	 */
	@SuppressWarnings("unchecked")
	public T taskMaxThreads(Integer value) {
		this.taskMaxThreads = value;
		return (T) this;
	}
}