package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Cached connection manager for resource adapters
 */
@ResourceType("cached-connection-manager")
@Implicit
public class CachedConnectionManager<T extends CachedConnectionManager> {

	private String key;
	private Boolean debug;
	private Boolean error;
	private Boolean ignoreUnknownConnections;
	private Boolean install;

	public CachedConnectionManager() {
		this.key = "cached-connection-manager";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Enable/disable debug information logging
	 */
	@ModelNodeBinding(detypedName = "debug")
	public Boolean debug() {
		return this.debug;
	}

	/**
	 * Enable/disable debug information logging
	 */
	@SuppressWarnings("unchecked")
	public T debug(Boolean value) {
		this.debug = value;
		return (T) this;
	}

	/**
	 * Enable/disable error information logging
	 */
	@ModelNodeBinding(detypedName = "error")
	public Boolean error() {
		return this.error;
	}

	/**
	 * Enable/disable error information logging
	 */
	@SuppressWarnings("unchecked")
	public T error(Boolean value) {
		this.error = value;
		return (T) this;
	}

	/**
	 * Do not cache unknown connections
	 */
	@ModelNodeBinding(detypedName = "ignore-unknown-connections")
	public Boolean ignoreUnknownConnections() {
		return this.ignoreUnknownConnections;
	}

	/**
	 * Do not cache unknown connections
	 */
	@SuppressWarnings("unchecked")
	public T ignoreUnknownConnections(Boolean value) {
		this.ignoreUnknownConnections = value;
		return (T) this;
	}

	/**
	 * Enable/disable the cached connection manager valve and interceptor
	 */
	@ModelNodeBinding(detypedName = "install")
	public Boolean install() {
		return this.install;
	}

	/**
	 * Enable/disable the cached connection manager valve and interceptor
	 */
	@SuppressWarnings("unchecked")
	public T install(Boolean value) {
		this.install = value;
		return (T) this;
	}
}