package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Tracer for resource adapters
 */
@ResourceType("tracer")
@Implicit
public class Tracer<T extends Tracer> {

	private String key;
	private Boolean enabled;

	public Tracer() {
		this.key = "tracer";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Specify whether tracer is enabled
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Specify whether tracer is enabled
	 */
	@SuppressWarnings("unchecked")
	public T enabled(Boolean value) {
		this.enabled = value;
		return (T) this;
	}
}