package org.wildfly.swarm.config.messaging_activemq;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging_activemq.server.ConnectorService;
import org.wildfly.swarm.config.messaging_activemq.server.ConnectorServiceConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor;
import org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptorConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection;
import org.wildfly.swarm.config.messaging_activemq.server.ClusterConnectionConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup;
import org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroupConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue;
import org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueueConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.AddressSetting;
import org.wildfly.swarm.config.messaging_activemq.server.AddressSettingConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.JMSQueue;
import org.wildfly.swarm.config.messaging_activemq.server.JMSQueueConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory;
import org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactoryConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.Divert;
import org.wildfly.swarm.config.messaging_activemq.server.DivertConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor;
import org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptorConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup;
import org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroupConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector;
import org.wildfly.swarm.config.messaging_activemq.server.HTTPConnectorConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory;
import org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactoryConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.Acceptor;
import org.wildfly.swarm.config.messaging_activemq.server.AcceptorConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor;
import org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptorConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector;
import org.wildfly.swarm.config.messaging_activemq.server.RemoteConnectorConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.InVMConnector;
import org.wildfly.swarm.config.messaging_activemq.server.InVMConnectorConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory;
import org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactoryConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler;
import org.wildfly.swarm.config.messaging_activemq.server.GroupingHandlerConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.JMSTopic;
import org.wildfly.swarm.config.messaging_activemq.server.JMSTopicConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.Connector;
import org.wildfly.swarm.config.messaging_activemq.server.ConnectorConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting;
import org.wildfly.swarm.config.messaging_activemq.server.SecuritySettingConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.CoreAddress;
import org.wildfly.swarm.config.messaging_activemq.server.CoreAddressConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.Bridge;
import org.wildfly.swarm.config.messaging_activemq.server.BridgeConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.Queue;
import org.wildfly.swarm.config.messaging_activemq.server.QueueConfigurator;
import org.wildfly.swarm.config.messaging_activemq.server.SharedStoreColocatedHAPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.ReplicationMasterHAPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.SharedStoreMasterHAPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.BindingsDirectoryPath;
import org.wildfly.swarm.config.messaging_activemq.server.ReplicationColocatedHAPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.JournalDirectoryPath;
import org.wildfly.swarm.config.messaging_activemq.server.SharedStoreSlaveHAPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.PagingDirectoryPath;
import org.wildfly.swarm.config.messaging_activemq.server.LargeMessagesDirectoryPath;
import org.wildfly.swarm.config.messaging_activemq.server.LiveOnlyHAPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.ReplicationSlaveHAPolicy;
/**
 * An ActiveMQ server instance.
 */
@ResourceType("server")
public class Server<T extends Server> {

	private String key;
	private Boolean active;
	private Boolean asyncConnectionExecutionEnabled;
	private Long connectionTtlOverride;
	private Integer idCacheSize;
	private List<java.util.Map> incomingInterceptors;
	private List<java.util.Map> outgoingInterceptors;
	private Integer pageMaxConcurrentIo;
	private Boolean persistDeliveryCountBeforeDelivery;
	private Boolean persistIdCache;
	private Boolean persistenceEnabled;
	private Integer scheduledThreadPoolMaxSize;
	private Boolean started;
	private Integer threadPoolMaxSize;
	private String version;
	private Boolean wildCardRoutingEnabled;
	private String clusterPassword;
	private String clusterUser;
	private Long memoryMeasureInterval;
	private Integer memoryWarningThreshold;
	private Integer perfBlastPages;
	private Boolean runSyncSpeedTest;
	private Long serverDumpInterval;
	private Boolean createBindingsDir;
	private Boolean createJournalDir;
	private Long journalBufferSize;
	private Long journalBufferTimeout;
	private Integer journalCompactMinFiles;
	private Integer journalCompactPercentage;
	private Long journalFileSize;
	private Integer journalMaxIo;
	private Integer journalMinFiles;
	private Boolean journalSyncNonTransactional;
	private Boolean journalSyncTransactional;
	private String journalType;
	private Boolean logJournalWriteRate;
	private String jmxDomain;
	private Boolean jmxManagementEnabled;
	private String managementAddress;
	private String managementNotificationAddress;
	private Long messageExpiryScanPeriod;
	private Integer messageExpiryThreadPriority;
	private Boolean overrideInVmSecurity;
	private String securityDomain;
	private Boolean securityEnabled;
	private Long securityInvalidationInterval;
	private Integer messageCounterMaxDayHistory;
	private Long messageCounterSamplePeriod;
	private Boolean statisticsEnabled;
	private Long transactionTimeout;
	private Long transactionTimeoutScanPeriod;
	private ServerResources subresources = new ServerResources();
	private SharedStoreColocatedHAPolicy sharedStoreColocatedHaPolicy;
	private ReplicationMasterHAPolicy replicationMasterHaPolicy;
	private SharedStoreMasterHAPolicy sharedStoreMasterHaPolicy;
	private BindingsDirectoryPath bindingsDirectoryPath;
	private ReplicationColocatedHAPolicy replicationColocatedHaPolicy;
	private JournalDirectoryPath journalDirectoryPath;
	private SharedStoreSlaveHAPolicy sharedStoreSlaveHaPolicy;
	private PagingDirectoryPath pagingDirectoryPath;
	private LargeMessagesDirectoryPath largeMessagesDirectoryPath;
	private LiveOnlyHAPolicy liveOnlyHaPolicy;
	private ReplicationSlaveHAPolicy replicationSlaveHaPolicy;

	public Server(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether the server is active (and accepting connections) or passive (in backup mode, waiting for failover).
	 */
	@ModelNodeBinding(detypedName = "active")
	public Boolean active() {
		return this.active;
	}

	/**
	 * Whether the server is active (and accepting connections) or passive (in backup mode, waiting for failover).
	 */
	@SuppressWarnings("unchecked")
	public T active(Boolean value) {
		this.active = value;
		return (T) this;
	}

	/**
	 * Whether incoming packets on the server should be handed off to a thread from the thread pool for processing. False if they should be handled on the remoting thread.
	 */
	@ModelNodeBinding(detypedName = "async-connection-execution-enabled")
	public Boolean asyncConnectionExecutionEnabled() {
		return this.asyncConnectionExecutionEnabled;
	}

	/**
	 * Whether incoming packets on the server should be handed off to a thread from the thread pool for processing. False if they should be handled on the remoting thread.
	 */
	@SuppressWarnings("unchecked")
	public T asyncConnectionExecutionEnabled(Boolean value) {
		this.asyncConnectionExecutionEnabled = value;
		return (T) this;
	}

	/**
	 * If set, this will override how long (in ms) to keep a connection alive without receiving a ping.
	 */
	@ModelNodeBinding(detypedName = "connection-ttl-override")
	public Long connectionTtlOverride() {
		return this.connectionTtlOverride;
	}

	/**
	 * If set, this will override how long (in ms) to keep a connection alive without receiving a ping.
	 */
	@SuppressWarnings("unchecked")
	public T connectionTtlOverride(Long value) {
		this.connectionTtlOverride = value;
		return (T) this;
	}

	/**
	 * The size of the cache for pre-creating message IDs.
	 */
	@ModelNodeBinding(detypedName = "id-cache-size")
	public Integer idCacheSize() {
		return this.idCacheSize;
	}

	/**
	 * The size of the cache for pre-creating message IDs.
	 */
	@SuppressWarnings("unchecked")
	public T idCacheSize(Integer value) {
		this.idCacheSize = value;
		return (T) this;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@ModelNodeBinding(detypedName = "incoming-interceptors")
	public List<Map> incomingInterceptors() {
		return this.incomingInterceptors;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T incomingInterceptors(List<java.util.Map> value) {
		this.incomingInterceptors = value;
		return (T) this;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	public T incomingInterceptor(Map value) {
		if (this.incomingInterceptors == null) {
			this.incomingInterceptors = new java.util.ArrayList<>();
		}
		this.incomingInterceptors.add(value);
		return (T) this;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@ModelNodeBinding(detypedName = "outgoing-interceptors")
	public List<Map> outgoingInterceptors() {
		return this.outgoingInterceptors;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T outgoingInterceptors(List<java.util.Map> value) {
		this.outgoingInterceptors = value;
		return (T) this;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	public T outgoingInterceptor(Map value) {
		if (this.outgoingInterceptors == null) {
			this.outgoingInterceptors = new java.util.ArrayList<>();
		}
		this.outgoingInterceptors.add(value);
		return (T) this;
	}

	/**
	 * The maximum number of concurrent reads allowed on paging
	 */
	@ModelNodeBinding(detypedName = "page-max-concurrent-io")
	public Integer pageMaxConcurrentIo() {
		return this.pageMaxConcurrentIo;
	}

	/**
	 * The maximum number of concurrent reads allowed on paging
	 */
	@SuppressWarnings("unchecked")
	public T pageMaxConcurrentIo(Integer value) {
		this.pageMaxConcurrentIo = value;
		return (T) this;
	}

	/**
	 * Whether the delivery count is persisted before delivery. False means that this only happens after a message has been cancelled.
	 */
	@ModelNodeBinding(detypedName = "persist-delivery-count-before-delivery")
	public Boolean persistDeliveryCountBeforeDelivery() {
		return this.persistDeliveryCountBeforeDelivery;
	}

	/**
	 * Whether the delivery count is persisted before delivery. False means that this only happens after a message has been cancelled.
	 */
	@SuppressWarnings("unchecked")
	public T persistDeliveryCountBeforeDelivery(Boolean value) {
		this.persistDeliveryCountBeforeDelivery = value;
		return (T) this;
	}

	/**
	 * Whether IDs are persisted to the journal.
	 */
	@ModelNodeBinding(detypedName = "persist-id-cache")
	public Boolean persistIdCache() {
		return this.persistIdCache;
	}

	/**
	 * Whether IDs are persisted to the journal.
	 */
	@SuppressWarnings("unchecked")
	public T persistIdCache(Boolean value) {
		this.persistIdCache = value;
		return (T) this;
	}

	/**
	 * Whether the server will use the file based journal for persistence.
	 */
	@ModelNodeBinding(detypedName = "persistence-enabled")
	public Boolean persistenceEnabled() {
		return this.persistenceEnabled;
	}

	/**
	 * Whether the server will use the file based journal for persistence.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceEnabled(Boolean value) {
		this.persistenceEnabled = value;
		return (T) this;
	}

	/**
	 * The number of threads that the main scheduled thread pool has.
	 */
	@ModelNodeBinding(detypedName = "scheduled-thread-pool-max-size")
	public Integer scheduledThreadPoolMaxSize() {
		return this.scheduledThreadPoolMaxSize;
	}

	/**
	 * The number of threads that the main scheduled thread pool has.
	 */
	@SuppressWarnings("unchecked")
	public T scheduledThreadPoolMaxSize(Integer value) {
		this.scheduledThreadPoolMaxSize = value;
		return (T) this;
	}

	/**
	 * Whether this server is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether this server is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(Boolean value) {
		this.started = value;
		return (T) this;
	}

	/**
	 * The number of threads that the main thread pool has. -1 means no limit.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-max-size")
	public Integer threadPoolMaxSize() {
		return this.threadPoolMaxSize;
	}

	/**
	 * The number of threads that the main thread pool has. -1 means no limit.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolMaxSize(Integer value) {
		this.threadPoolMaxSize = value;
		return (T) this;
	}

	/**
	 * The server's version.
	 */
	@ModelNodeBinding(detypedName = "version")
	public String version() {
		return this.version;
	}

	/**
	 * The server's version.
	 */
	@SuppressWarnings("unchecked")
	public T version(String value) {
		this.version = value;
		return (T) this;
	}

	/**
	 * Whether the server supports wild card routing.
	 */
	@ModelNodeBinding(detypedName = "wild-card-routing-enabled")
	public Boolean wildCardRoutingEnabled() {
		return this.wildCardRoutingEnabled;
	}

	/**
	 * Whether the server supports wild card routing.
	 */
	@SuppressWarnings("unchecked")
	public T wildCardRoutingEnabled(Boolean value) {
		this.wildCardRoutingEnabled = value;
		return (T) this;
	}

	/**
	 * The password used by cluster connections to communicate between the clustered nodes.
	 */
	@ModelNodeBinding(detypedName = "cluster-password")
	public String clusterPassword() {
		return this.clusterPassword;
	}

	/**
	 * The password used by cluster connections to communicate between the clustered nodes.
	 */
	@SuppressWarnings("unchecked")
	public T clusterPassword(String value) {
		this.clusterPassword = value;
		return (T) this;
	}

	/**
	 * The user used by cluster connections to communicate between the clustered nodes.
	 */
	@ModelNodeBinding(detypedName = "cluster-user")
	public String clusterUser() {
		return this.clusterUser;
	}

	/**
	 * The user used by cluster connections to communicate between the clustered nodes.
	 */
	@SuppressWarnings("unchecked")
	public T clusterUser(String value) {
		this.clusterUser = value;
		return (T) this;
	}

	/**
	 * Frequency to sample JVM memory in ms (or -1 to disable memory sampling)
	 */
	@ModelNodeBinding(detypedName = "memory-measure-interval")
	public Long memoryMeasureInterval() {
		return this.memoryMeasureInterval;
	}

	/**
	 * Frequency to sample JVM memory in ms (or -1 to disable memory sampling)
	 */
	@SuppressWarnings("unchecked")
	public T memoryMeasureInterval(Long value) {
		this.memoryMeasureInterval = value;
		return (T) this;
	}

	/**
	 * Percentage of available memory which if exceeded results in a warning log
	 */
	@ModelNodeBinding(detypedName = "memory-warning-threshold")
	public Integer memoryWarningThreshold() {
		return this.memoryWarningThreshold;
	}

	/**
	 * Percentage of available memory which if exceeded results in a warning log
	 */
	@SuppressWarnings("unchecked")
	public T memoryWarningThreshold(Integer value) {
		this.memoryWarningThreshold = value;
		return (T) this;
	}

	/**
	 * TODO
	 */
	@ModelNodeBinding(detypedName = "perf-blast-pages")
	public Integer perfBlastPages() {
		return this.perfBlastPages;
	}

	/**
	 * TODO
	 */
	@SuppressWarnings("unchecked")
	public T perfBlastPages(Integer value) {
		this.perfBlastPages = value;
		return (T) this;
	}

	/**
	 * Whether on startup to perform a diagnostic test on how fast your disk can sync. Useful when determining performance issues.
	 */
	@ModelNodeBinding(detypedName = "run-sync-speed-test")
	public Boolean runSyncSpeedTest() {
		return this.runSyncSpeedTest;
	}

	/**
	 * Whether on startup to perform a diagnostic test on how fast your disk can sync. Useful when determining performance issues.
	 */
	@SuppressWarnings("unchecked")
	public T runSyncSpeedTest(Boolean value) {
		this.runSyncSpeedTest = value;
		return (T) this;
	}

	/**
	 * How often to dump basic runtime information to the server log. A value less than 1 disables this feature.
	 */
	@ModelNodeBinding(detypedName = "server-dump-interval")
	public Long serverDumpInterval() {
		return this.serverDumpInterval;
	}

	/**
	 * How often to dump basic runtime information to the server log. A value less than 1 disables this feature.
	 */
	@SuppressWarnings("unchecked")
	public T serverDumpInterval(Long value) {
		this.serverDumpInterval = value;
		return (T) this;
	}

	/**
	 * Whether the server should create the bindings directory on start up.
	 */
	@ModelNodeBinding(detypedName = "create-bindings-dir")
	public Boolean createBindingsDir() {
		return this.createBindingsDir;
	}

	/**
	 * Whether the server should create the bindings directory on start up.
	 */
	@SuppressWarnings("unchecked")
	public T createBindingsDir(Boolean value) {
		this.createBindingsDir = value;
		return (T) this;
	}

	/**
	 * Whether the server should create the journal directory on start up.
	 */
	@ModelNodeBinding(detypedName = "create-journal-dir")
	public Boolean createJournalDir() {
		return this.createJournalDir;
	}

	/**
	 * Whether the server should create the journal directory on start up.
	 */
	@SuppressWarnings("unchecked")
	public T createJournalDir(Boolean value) {
		this.createJournalDir = value;
		return (T) this;
	}

	/**
	 * The size of the internal buffer on the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-buffer-size")
	public Long journalBufferSize() {
		return this.journalBufferSize;
	}

	/**
	 * The size of the internal buffer on the journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalBufferSize(Long value) {
		this.journalBufferSize = value;
		return (T) this;
	}

	/**
	 * The timeout (in nanoseconds) used to flush internal buffers on the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-buffer-timeout")
	public Long journalBufferTimeout() {
		return this.journalBufferTimeout;
	}

	/**
	 * The timeout (in nanoseconds) used to flush internal buffers on the journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalBufferTimeout(Long value) {
		this.journalBufferTimeout = value;
		return (T) this;
	}

	/**
	 * The minimal number of journal data files before we can start compacting.
	 */
	@ModelNodeBinding(detypedName = "journal-compact-min-files")
	public Integer journalCompactMinFiles() {
		return this.journalCompactMinFiles;
	}

	/**
	 * The minimal number of journal data files before we can start compacting.
	 */
	@SuppressWarnings("unchecked")
	public T journalCompactMinFiles(Integer value) {
		this.journalCompactMinFiles = value;
		return (T) this;
	}

	/**
	 * The percentage of live data on which we consider compacting the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-compact-percentage")
	public Integer journalCompactPercentage() {
		return this.journalCompactPercentage;
	}

	/**
	 * The percentage of live data on which we consider compacting the journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalCompactPercentage(Integer value) {
		this.journalCompactPercentage = value;
		return (T) this;
	}

	/**
	 * The size (in bytes) of each journal file.
	 */
	@ModelNodeBinding(detypedName = "journal-file-size")
	public Long journalFileSize() {
		return this.journalFileSize;
	}

	/**
	 * The size (in bytes) of each journal file.
	 */
	@SuppressWarnings("unchecked")
	public T journalFileSize(Long value) {
		this.journalFileSize = value;
		return (T) this;
	}

	/**
	 * The maximum number of write requests that can be in the AIO queue at any one time.
	 */
	@ModelNodeBinding(detypedName = "journal-max-io")
	public Integer journalMaxIo() {
		return this.journalMaxIo;
	}

	/**
	 * The maximum number of write requests that can be in the AIO queue at any one time.
	 */
	@SuppressWarnings("unchecked")
	public T journalMaxIo(Integer value) {
		this.journalMaxIo = value;
		return (T) this;
	}

	/**
	 * How many journal files to pre-create.
	 */
	@ModelNodeBinding(detypedName = "journal-min-files")
	public Integer journalMinFiles() {
		return this.journalMinFiles;
	}

	/**
	 * How many journal files to pre-create.
	 */
	@SuppressWarnings("unchecked")
	public T journalMinFiles(Integer value) {
		this.journalMinFiles = value;
		return (T) this;
	}

	/**
	 * Whether to wait for non transaction data to be synced to the journal before returning a response to the client.
	 */
	@ModelNodeBinding(detypedName = "journal-sync-non-transactional")
	public Boolean journalSyncNonTransactional() {
		return this.journalSyncNonTransactional;
	}

	/**
	 * Whether to wait for non transaction data to be synced to the journal before returning a response to the client.
	 */
	@SuppressWarnings("unchecked")
	public T journalSyncNonTransactional(Boolean value) {
		this.journalSyncNonTransactional = value;
		return (T) this;
	}

	/**
	 * Whether to wait for transaction data to be synchronized to the journal before returning a response to the client.
	 */
	@ModelNodeBinding(detypedName = "journal-sync-transactional")
	public Boolean journalSyncTransactional() {
		return this.journalSyncTransactional;
	}

	/**
	 * Whether to wait for transaction data to be synchronized to the journal before returning a response to the client.
	 */
	@SuppressWarnings("unchecked")
	public T journalSyncTransactional(Boolean value) {
		this.journalSyncTransactional = value;
		return (T) this;
	}

	/**
	 * The type of journal to use.
	 */
	@ModelNodeBinding(detypedName = "journal-type")
	public String journalType() {
		return this.journalType;
	}

	/**
	 * The type of journal to use.
	 */
	@SuppressWarnings("unchecked")
	public T journalType(String value) {
		this.journalType = value;
		return (T) this;
	}

	/**
	 * Whether to periodically log the journal's write rate and flush rate.
	 */
	@ModelNodeBinding(detypedName = "log-journal-write-rate")
	public Boolean logJournalWriteRate() {
		return this.logJournalWriteRate;
	}

	/**
	 * Whether to periodically log the journal's write rate and flush rate.
	 */
	@SuppressWarnings("unchecked")
	public T logJournalWriteRate(Boolean value) {
		this.logJournalWriteRate = value;
		return (T) this;
	}

	/**
	 * The JMX domain used to register internal ActiveMQ MBeans in the MBeanServer.
	 */
	@ModelNodeBinding(detypedName = "jmx-domain")
	public String jmxDomain() {
		return this.jmxDomain;
	}

	/**
	 * The JMX domain used to register internal ActiveMQ MBeans in the MBeanServer.
	 */
	@SuppressWarnings("unchecked")
	public T jmxDomain(String value) {
		this.jmxDomain = value;
		return (T) this;
	}

	/**
	 * Whether ActiveMQ should expose its internal management API via JMX. This is not recommended, as accessing these MBeans can lead to inconsistent configuration.
	 */
	@ModelNodeBinding(detypedName = "jmx-management-enabled")
	public Boolean jmxManagementEnabled() {
		return this.jmxManagementEnabled;
	}

	/**
	 * Whether ActiveMQ should expose its internal management API via JMX. This is not recommended, as accessing these MBeans can lead to inconsistent configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jmxManagementEnabled(Boolean value) {
		this.jmxManagementEnabled = value;
		return (T) this;
	}

	/**
	 * Address to send management messages to.
	 */
	@ModelNodeBinding(detypedName = "management-address")
	public String managementAddress() {
		return this.managementAddress;
	}

	/**
	 * Address to send management messages to.
	 */
	@SuppressWarnings("unchecked")
	public T managementAddress(String value) {
		this.managementAddress = value;
		return (T) this;
	}

	/**
	 * The name of the address that consumers bind to  to receive management notifications.
	 */
	@ModelNodeBinding(detypedName = "management-notification-address")
	public String managementNotificationAddress() {
		return this.managementNotificationAddress;
	}

	/**
	 * The name of the address that consumers bind to  to receive management notifications.
	 */
	@SuppressWarnings("unchecked")
	public T managementNotificationAddress(String value) {
		this.managementNotificationAddress = value;
		return (T) this;
	}

	/**
	 * How often (in ms) to scan for expired messages.
	 */
	@ModelNodeBinding(detypedName = "message-expiry-scan-period")
	public Long messageExpiryScanPeriod() {
		return this.messageExpiryScanPeriod;
	}

	/**
	 * How often (in ms) to scan for expired messages.
	 */
	@SuppressWarnings("unchecked")
	public T messageExpiryScanPeriod(Long value) {
		this.messageExpiryScanPeriod = value;
		return (T) this;
	}

	/**
	 * The priority of the thread expiring messages.
	 */
	@ModelNodeBinding(detypedName = "message-expiry-thread-priority")
	public Integer messageExpiryThreadPriority() {
		return this.messageExpiryThreadPriority;
	}

	/**
	 * The priority of the thread expiring messages.
	 */
	@SuppressWarnings("unchecked")
	public T messageExpiryThreadPriority(Integer value) {
		this.messageExpiryThreadPriority = value;
		return (T) this;
	}

	/**
	 * Whether the ActiveMQ server will override security credentials for in-vm connections.
	 */
	@ModelNodeBinding(detypedName = "override-in-vm-security")
	public Boolean overrideInVmSecurity() {
		return this.overrideInVmSecurity;
	}

	/**
	 * Whether the ActiveMQ server will override security credentials for in-vm connections.
	 */
	@SuppressWarnings("unchecked")
	public T overrideInVmSecurity(Boolean value) {
		this.overrideInVmSecurity = value;
		return (T) this;
	}

	/**
	 * The security domain to use to verify user and role information
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * The security domain to use to verify user and role information
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(String value) {
		this.securityDomain = value;
		return (T) this;
	}

	/**
	 * Whether security is enabled.
	 */
	@ModelNodeBinding(detypedName = "security-enabled")
	public Boolean securityEnabled() {
		return this.securityEnabled;
	}

	/**
	 * Whether security is enabled.
	 */
	@SuppressWarnings("unchecked")
	public T securityEnabled(Boolean value) {
		this.securityEnabled = value;
		return (T) this;
	}

	/**
	 * How long (in ms) to wait before invalidating the security cache.
	 */
	@ModelNodeBinding(detypedName = "security-invalidation-interval")
	public Long securityInvalidationInterval() {
		return this.securityInvalidationInterval;
	}

	/**
	 * How long (in ms) to wait before invalidating the security cache.
	 */
	@SuppressWarnings("unchecked")
	public T securityInvalidationInterval(Long value) {
		this.securityInvalidationInterval = value;
		return (T) this;
	}

	/**
	 * How many days to keep message counter history.
	 */
	@ModelNodeBinding(detypedName = "message-counter-max-day-history")
	public Integer messageCounterMaxDayHistory() {
		return this.messageCounterMaxDayHistory;
	}

	/**
	 * How many days to keep message counter history.
	 */
	@SuppressWarnings("unchecked")
	public T messageCounterMaxDayHistory(Integer value) {
		this.messageCounterMaxDayHistory = value;
		return (T) this;
	}

	/**
	 * The sample period (in ms) to use for message counters.
	 */
	@ModelNodeBinding(detypedName = "message-counter-sample-period")
	public Long messageCounterSamplePeriod() {
		return this.messageCounterSamplePeriod;
	}

	/**
	 * The sample period (in ms) to use for message counters.
	 */
	@SuppressWarnings("unchecked")
	public T messageCounterSamplePeriod(Long value) {
		this.messageCounterSamplePeriod = value;
		return (T) this;
	}

	/**
	 * Whether gathering of statistics such as message counters are enabled.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Whether gathering of statistics such as message counters are enabled.
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(Boolean value) {
		this.statisticsEnabled = value;
		return (T) this;
	}

	/**
	 * How long (in ms) before a transaction can be removed from the resource manager after create time.
	 */
	@ModelNodeBinding(detypedName = "transaction-timeout")
	public Long transactionTimeout() {
		return this.transactionTimeout;
	}

	/**
	 * How long (in ms) before a transaction can be removed from the resource manager after create time.
	 */
	@SuppressWarnings("unchecked")
	public T transactionTimeout(Long value) {
		this.transactionTimeout = value;
		return (T) this;
	}

	/**
	 * How often (in ms) to scan for timeout transactions.
	 */
	@ModelNodeBinding(detypedName = "transaction-timeout-scan-period")
	public Long transactionTimeoutScanPeriod() {
		return this.transactionTimeoutScanPeriod;
	}

	/**
	 * How often (in ms) to scan for timeout transactions.
	 */
	@SuppressWarnings("unchecked")
	public T transactionTimeoutScanPeriod(Long value) {
		this.transactionTimeoutScanPeriod = value;
		return (T) this;
	}

	public ServerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.ConnectorService objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.ConnectorService objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectorServices(
			List<org.wildfly.swarm.config.messaging_activemq.server.ConnectorService> value) {
		this.subresources.connectorServices = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.ConnectorService object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.ConnectorService to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(ConnectorService value) {
		this.subresources.connectorServices.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.ConnectorService object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.ConnectorService resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.ConnectorServiceConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(String childKey,
			ConnectorServiceConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.ConnectorService child = new org.wildfly.swarm.config.messaging_activemq.server.ConnectorService(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		connectorService(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.ConnectorService object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.ConnectorService resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(String childKey) {
		connectorService(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptors(
			List<org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor> value) {
		this.subresources.httpAcceptors = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(HTTPAcceptor value) {
		this.subresources.httpAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptorConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(String childKey, HTTPAcceptorConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor child = new org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		httpAcceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(String childKey) {
		httpAcceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnections(
			List<org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection> value) {
		this.subresources.clusterConnections = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(ClusterConnection value) {
		this.subresources.clusterConnections.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.ClusterConnectionConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(String childKey,
			ClusterConnectionConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection child = new org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		clusterConnection(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(String childKey) {
		clusterConnection(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroups(
			List<org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup> value) {
		this.subresources.broadcastGroups = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(BroadcastGroup value) {
		this.subresources.broadcastGroups.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroupConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(String childKey, BroadcastGroupConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup child = new org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		broadcastGroup(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(String childKey) {
		broadcastGroup(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue objects.
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueues(
			List<org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue> value) {
		this.subresources.runtimeQueues = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(RuntimeQueue value) {
		this.subresources.runtimeQueues.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueueConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(String childKey, RuntimeQueueConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue child = new org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		runtimeQueue(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(String childKey) {
		runtimeQueue(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.AddressSetting objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.AddressSetting objects.
	 */
	@SuppressWarnings("unchecked")
	public T addressSettings(
			List<org.wildfly.swarm.config.messaging_activemq.server.AddressSetting> value) {
		this.subresources.addressSettings = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.AddressSetting object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.AddressSetting to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(AddressSetting value) {
		this.subresources.addressSettings.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.AddressSetting object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.AddressSetting resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.AddressSettingConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(String childKey, AddressSettingConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.AddressSetting child = new org.wildfly.swarm.config.messaging_activemq.server.AddressSetting(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		addressSetting(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.AddressSetting object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.AddressSetting resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(String childKey) {
		addressSetting(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.JMSQueue objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.JMSQueue objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueues(
			List<org.wildfly.swarm.config.messaging_activemq.server.JMSQueue> value) {
		this.subresources.jmsQueues = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.JMSQueue object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.JMSQueue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(JMSQueue value) {
		this.subresources.jmsQueues.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.JMSQueue object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.JMSQueue resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.JMSQueueConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(String childKey, JMSQueueConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.JMSQueue child = new org.wildfly.swarm.config.messaging_activemq.server.JMSQueue(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		jmsQueue(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.JMSQueue object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.JMSQueue resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(String childKey) {
		jmsQueue(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactorys(
			List<org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory> value) {
		this.subresources.pooledConnectionFactorys = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(PooledConnectionFactory value) {
		this.subresources.pooledConnectionFactorys.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactoryConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(String childKey,
			PooledConnectionFactoryConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory child = new org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		pooledConnectionFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(String childKey) {
		pooledConnectionFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Divert objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Divert objects.
	 */
	@SuppressWarnings("unchecked")
	public T diverts(
			List<org.wildfly.swarm.config.messaging_activemq.server.Divert> value) {
		this.subresources.diverts = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Divert object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Divert to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T divert(Divert value) {
		this.subresources.diverts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Divert object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Divert resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.DivertConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T divert(String childKey, DivertConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.Divert child = new org.wildfly.swarm.config.messaging_activemq.server.Divert(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		divert(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Divert object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Divert resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T divert(String childKey) {
		divert(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptors(
			List<org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor> value) {
		this.subresources.inVmAcceptors = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(InVMAcceptor value) {
		this.subresources.inVmAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptorConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(String childKey, InVMAcceptorConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor child = new org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		inVmAcceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(String childKey) {
		inVmAcceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroups(
			List<org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup> value) {
		this.subresources.discoveryGroups = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(DiscoveryGroup value) {
		this.subresources.discoveryGroups.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroupConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(String childKey, DiscoveryGroupConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup child = new org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		discoveryGroup(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(String childKey) {
		discoveryGroup(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpConnectors(
			List<org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector> value) {
		this.subresources.httpConnectors = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HTTPConnector value) {
		this.subresources.httpConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.HTTPConnectorConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(String childKey, HTTPConnectorConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector child = new org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		httpConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(String childKey) {
		httpConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactorys(
			List<org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory> value) {
		this.subresources.connectionFactorys = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(ConnectionFactory value) {
		this.subresources.connectionFactorys.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactoryConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(String childKey,
			ConnectionFactoryConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory child = new org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		connectionFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(String childKey) {
		connectionFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Acceptor objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Acceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T acceptors(
			List<org.wildfly.swarm.config.messaging_activemq.server.Acceptor> value) {
		this.subresources.acceptors = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Acceptor object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Acceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(Acceptor value) {
		this.subresources.acceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Acceptor object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Acceptor resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.AcceptorConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(String childKey, AcceptorConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.Acceptor child = new org.wildfly.swarm.config.messaging_activemq.server.Acceptor(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		acceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Acceptor object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Acceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(String childKey) {
		acceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptors(
			List<org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor> value) {
		this.subresources.remoteAcceptors = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(RemoteAcceptor value) {
		this.subresources.remoteAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptorConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(String childKey, RemoteAcceptorConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor child = new org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		remoteAcceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(String childKey) {
		remoteAcceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnectors(
			List<org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector> value) {
		this.subresources.remoteConnectors = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(RemoteConnector value) {
		this.subresources.remoteConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.RemoteConnectorConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(String childKey, RemoteConnectorConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector child = new org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		remoteConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(String childKey) {
		remoteConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.InVMConnector objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.InVMConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnectors(
			List<org.wildfly.swarm.config.messaging_activemq.server.InVMConnector> value) {
		this.subresources.inVmConnectors = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.InVMConnector object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.InVMConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(InVMConnector value) {
		this.subresources.inVmConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.InVMConnector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.InVMConnector resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.InVMConnectorConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(String childKey, InVMConnectorConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.InVMConnector child = new org.wildfly.swarm.config.messaging_activemq.server.InVMConnector(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		inVmConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.InVMConnector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.InVMConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(String childKey) {
		inVmConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactorys(
			List<org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory> value) {
		this.subresources.legacyConnectionFactorys = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(LegacyConnectionFactory value) {
		this.subresources.legacyConnectionFactorys.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactoryConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(String childKey,
			LegacyConnectionFactoryConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory child = new org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		legacyConnectionFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(String childKey) {
		legacyConnectionFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandlers(
			List<org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler> value) {
		this.subresources.groupingHandlers = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(GroupingHandler value) {
		this.subresources.groupingHandlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.GroupingHandlerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(String childKey, GroupingHandlerConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler child = new org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		groupingHandler(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(String childKey) {
		groupingHandler(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.JMSTopic objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.JMSTopic objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopics(
			List<org.wildfly.swarm.config.messaging_activemq.server.JMSTopic> value) {
		this.subresources.jmsTopics = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.JMSTopic object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.JMSTopic to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(JMSTopic value) {
		this.subresources.jmsTopics.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.JMSTopic object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.JMSTopic resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.JMSTopicConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(String childKey, JMSTopicConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.JMSTopic child = new org.wildfly.swarm.config.messaging_activemq.server.JMSTopic(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		jmsTopic(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.JMSTopic object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.JMSTopic resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(String childKey) {
		jmsTopic(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Connector objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Connector objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(
			List<org.wildfly.swarm.config.messaging_activemq.server.Connector> value) {
		this.subresources.connectors = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Connector object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Connector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(Connector value) {
		this.subresources.connectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Connector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Connector resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.ConnectorConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(String childKey, ConnectorConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.Connector child = new org.wildfly.swarm.config.messaging_activemq.server.Connector(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		connector(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Connector object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Connector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(String childKey) {
		connector(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting objects.
	 */
	@SuppressWarnings("unchecked")
	public T securitySettings(
			List<org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting> value) {
		this.subresources.securitySettings = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(SecuritySetting value) {
		this.subresources.securitySettings.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.SecuritySettingConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(String childKey, SecuritySettingConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting child = new org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		securitySetting(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(String childKey) {
		securitySetting(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.CoreAddress objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.CoreAddress objects.
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(
			List<org.wildfly.swarm.config.messaging_activemq.server.CoreAddress> value) {
		this.subresources.coreAddress = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.CoreAddress object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.CoreAddress to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(CoreAddress value) {
		this.subresources.coreAddress.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.CoreAddress object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.CoreAddress resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.CoreAddressConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(String childKey, CoreAddressConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.CoreAddress child = new org.wildfly.swarm.config.messaging_activemq.server.CoreAddress(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		coreAddress(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.CoreAddress object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.CoreAddress resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(String childKey) {
		coreAddress(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Bridge objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Bridge objects.
	 */
	@SuppressWarnings("unchecked")
	public T bridges(
			List<org.wildfly.swarm.config.messaging_activemq.server.Bridge> value) {
		this.subresources.bridges = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Bridge object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Bridge to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bridge(Bridge value) {
		this.subresources.bridges.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Bridge object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Bridge resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.BridgeConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bridge(String childKey, BridgeConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.Bridge child = new org.wildfly.swarm.config.messaging_activemq.server.Bridge(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		bridge(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Bridge object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Bridge resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bridge(String childKey) {
		bridge(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Queue objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Queue objects.
	 */
	@SuppressWarnings("unchecked")
	public T queues(
			List<org.wildfly.swarm.config.messaging_activemq.server.Queue> value) {
		this.subresources.queues = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Queue object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Queue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T queue(Queue value) {
		this.subresources.queues.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Queue object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Queue resource
	 * @param config The org.wildfly.swarm.config.messaging_activemq.server.QueueConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T queue(String childKey, QueueConfigurator config) {
		org.wildfly.swarm.config.messaging_activemq.server.Queue child = new org.wildfly.swarm.config.messaging_activemq.server.Queue(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		queue(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.messaging_activemq.server.Queue object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.messaging_activemq.server.Queue resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T queue(String childKey) {
		queue(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for Server
	 */
	public class ServerResources {
		/**
		 * TODO
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.ConnectorService> connectorServices = new java.util.ArrayList<>();
		/**
		 * Defines a way in which remote connections can be made to the ActiveMQ server over HTTP.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor> httpAcceptors = new java.util.ArrayList<>();
		/**
		 * Cluster connections group servers into clusters so that messages can be load balanced between the nodes of the cluster.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection> clusterConnections = new java.util.ArrayList<>();
		/**
		 * A broadcast group is the means by which a server broadcasts connectors over the network.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup> broadcastGroups = new java.util.ArrayList<>();
		/**
		 * A Queue.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue> runtimeQueues = new java.util.ArrayList<>();
		/**
		 * An address setting defines some attributes that are defined against an address wildcard rather than a specific queue.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.AddressSetting> addressSettings = new java.util.ArrayList<>();
		/**
		 * Defines a JMS queue.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.JMSQueue> jmsQueues = new java.util.ArrayList<>();
		/**
		 * Defines a managed connection factory.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory> pooledConnectionFactorys = new java.util.ArrayList<>();
		/**
		 * A messaging resource that allows you to transparently divert messages routed to one address to some other address, without making any changes to any client application logic.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Divert> diverts = new java.util.ArrayList<>();
		/**
		 * Defines a way in which in-VM connections can be made to the ActiveMQ server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor> inVmAcceptors = new java.util.ArrayList<>();
		/**
		 * Multicast group to listen to receive broadcast from other servers announcing their connectors.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup> discoveryGroups = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server over HTTP.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector> httpConnectors = new java.util.ArrayList<>();
		/**
		 * Defines a connection factory.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory> connectionFactorys = new java.util.ArrayList<>();
		/**
		 * An acceptor defines a way in which connections can be made to the ActiveMQ server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Acceptor> acceptors = new java.util.ArrayList<>();
		/**
		 * Defines a way in which remote connections can be made to the ActiveMQ server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor> remoteAcceptors = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector> remoteConnectors = new java.util.ArrayList<>();
		/**
		 * Used by an in-VM client to define how it connects to a server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.InVMConnector> inVmConnectors = new java.util.ArrayList<>();
		/**
		 * Defines a connection factory.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory> legacyConnectionFactorys = new java.util.ArrayList<>();
		/**
		 * Makes decisions about which node in a cluster should handle a message with a group id assigned.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler> groupingHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a JMS topic.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.JMSTopic> jmsTopics = new java.util.ArrayList<>();
		/**
		 * A connector can be used by a client to define how it connects to a server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Connector> connectors = new java.util.ArrayList<>();
		/**
		 * A security setting allows sets of permissions to be defined against queues based on their address.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting> securitySettings = new java.util.ArrayList<>();
		/**
		 * A runtime-only resource representing a ActiveMQ "address". Zero or more queues can be bound to a single address. When a message is routed, it is routed to the set of queues bound to the message's address.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.CoreAddress> coreAddress = new java.util.ArrayList<>();
		/**
		 * The function of a bridge is to consume messages from a source queue, and forward them to a target address, typically on a different ActiveMQ server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Bridge> bridges = new java.util.ArrayList<>();
		/**
		 * A Queue.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Queue> queues = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.ConnectorService resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectorService> connectorServices() {
			return this.connectorServices;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HTTPAcceptor> httpAcceptors() {
			return this.httpAcceptors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ClusterConnection> clusterConnections() {
			return this.clusterConnections;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup resources
		 * @return the list of resources
		 */
		@Subresource
		public List<BroadcastGroup> broadcastGroups() {
			return this.broadcastGroups;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RuntimeQueue> runtimeQueues() {
			return this.runtimeQueues;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.AddressSetting resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AddressSetting> addressSettings() {
			return this.addressSettings;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.JMSQueue resources
		 * @return the list of resources
		 */
		@Subresource
		public List<JMSQueue> jmsQueues() {
			return this.jmsQueues;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory resources
		 * @return the list of resources
		 */
		@Subresource
		public List<PooledConnectionFactory> pooledConnectionFactorys() {
			return this.pooledConnectionFactorys;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Divert resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Divert> diverts() {
			return this.diverts;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.InVMAcceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<InVMAcceptor> inVmAcceptors() {
			return this.inVmAcceptors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup resources
		 * @return the list of resources
		 */
		@Subresource
		public List<DiscoveryGroup> discoveryGroups() {
			return this.discoveryGroups;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.HTTPConnector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HTTPConnector> httpConnectors() {
			return this.httpConnectors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectionFactory> connectionFactorys() {
			return this.connectionFactorys;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Acceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Acceptor> acceptors() {
			return this.acceptors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteAcceptor> remoteAcceptors() {
			return this.remoteAcceptors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteConnector> remoteConnectors() {
			return this.remoteConnectors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.InVMConnector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<InVMConnector> inVmConnectors() {
			return this.inVmConnectors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LegacyConnectionFactory> legacyConnectionFactorys() {
			return this.legacyConnectionFactorys;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler resources
		 * @return the list of resources
		 */
		@Subresource
		public List<GroupingHandler> groupingHandlers() {
			return this.groupingHandlers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.JMSTopic resources
		 * @return the list of resources
		 */
		@Subresource
		public List<JMSTopic> jmsTopics() {
			return this.jmsTopics;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Connector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Connector> connectors() {
			return this.connectors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting resources
		 * @return the list of resources
		 */
		@Subresource
		public List<SecuritySetting> securitySettings() {
			return this.securitySettings;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.CoreAddress resources
		 * @return the list of resources
		 */
		@Subresource
		public List<CoreAddress> coreAddress() {
			return this.coreAddress;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Bridge resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Bridge> bridges() {
			return this.bridges;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Queue resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Queue> queues() {
			return this.queues;
		}
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public SharedStoreColocatedHAPolicy sharedStoreColocatedHaPolicy() {
		return this.sharedStoreColocatedHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreColocatedHaPolicy(SharedStoreColocatedHAPolicy value) {
		this.sharedStoreColocatedHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public ReplicationMasterHAPolicy replicationMasterHaPolicy() {
		return this.replicationMasterHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationMasterHaPolicy(ReplicationMasterHAPolicy value) {
		this.replicationMasterHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public SharedStoreMasterHAPolicy sharedStoreMasterHaPolicy() {
		return this.sharedStoreMasterHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreMasterHaPolicy(SharedStoreMasterHAPolicy value) {
		this.sharedStoreMasterHaPolicy = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public BindingsDirectoryPath bindingsDirectoryPath() {
		return this.bindingsDirectoryPath;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T bindingsDirectoryPath(BindingsDirectoryPath value) {
		this.bindingsDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public ReplicationColocatedHAPolicy replicationColocatedHaPolicy() {
		return this.replicationColocatedHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationColocatedHaPolicy(ReplicationColocatedHAPolicy value) {
		this.replicationColocatedHaPolicy = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public JournalDirectoryPath journalDirectoryPath() {
		return this.journalDirectoryPath;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T journalDirectoryPath(JournalDirectoryPath value) {
		this.journalDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public SharedStoreSlaveHAPolicy sharedStoreSlaveHaPolicy() {
		return this.sharedStoreSlaveHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreSlaveHaPolicy(SharedStoreSlaveHAPolicy value) {
		this.sharedStoreSlaveHaPolicy = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public PagingDirectoryPath pagingDirectoryPath() {
		return this.pagingDirectoryPath;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pagingDirectoryPath(PagingDirectoryPath value) {
		this.pagingDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public LargeMessagesDirectoryPath largeMessagesDirectoryPath() {
		return this.largeMessagesDirectoryPath;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T largeMessagesDirectoryPath(LargeMessagesDirectoryPath value) {
		this.largeMessagesDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public LiveOnlyHAPolicy liveOnlyHaPolicy() {
		return this.liveOnlyHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T liveOnlyHaPolicy(LiveOnlyHAPolicy value) {
		this.liveOnlyHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public ReplicationSlaveHAPolicy replicationSlaveHaPolicy() {
		return this.replicationSlaveHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationSlaveHaPolicy(ReplicationSlaveHAPolicy value) {
		this.replicationSlaveHaPolicy = value;
		return (T) this;
	}
}