package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * An address setting defines some attributes that are defined against an address wildcard rather than a specific queue.
 */
@ResourceType("address-setting")
public class AddressSetting<T extends AddressSetting> {

	private String key;
	private String addressFullPolicy;
	private String deadLetterAddress;
	private String expiryAddress;
	private Long expiryDelay;
	private Boolean lastValueQueue;
	private Integer maxDeliveryAttempts;
	private Long maxRedeliveryDelay;
	private Long maxSizeBytes;
	private Integer messageCounterHistoryDayLimit;
	private Integer pageMaxCacheSize;
	private Long pageSizeBytes;
	private Long redeliveryDelay;
	private Double redeliveryMultiplier;
	private Long redistributionDelay;
	private Boolean sendToDlaOnNoRoute;
	private Long slowConsumerCheckPeriod;
	private String slowConsumerPolicy;
	private Long slowConsumerThreshold;

	public AddressSetting(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Determines what happens when an address where max-size-bytes is specified becomes full. (PAGE, DROP or BLOCK)
	 */
	@ModelNodeBinding(detypedName = "address-full-policy")
	public String addressFullPolicy() {
		return this.addressFullPolicy;
	}

	/**
	 * Determines what happens when an address where max-size-bytes is specified becomes full. (PAGE, DROP or BLOCK)
	 */
	@SuppressWarnings("unchecked")
	public T addressFullPolicy(String value) {
		this.addressFullPolicy = value;
		return (T) this;
	}

	/**
	 * The dead letter address
	 */
	@ModelNodeBinding(detypedName = "dead-letter-address")
	public String deadLetterAddress() {
		return this.deadLetterAddress;
	}

	/**
	 * The dead letter address
	 */
	@SuppressWarnings("unchecked")
	public T deadLetterAddress(String value) {
		this.deadLetterAddress = value;
		return (T) this;
	}

	/**
	 * Defines where to send a message that has expired.
	 */
	@ModelNodeBinding(detypedName = "expiry-address")
	public String expiryAddress() {
		return this.expiryAddress;
	}

	/**
	 * Defines where to send a message that has expired.
	 */
	@SuppressWarnings("unchecked")
	public T expiryAddress(String value) {
		this.expiryAddress = value;
		return (T) this;
	}

	/**
	 * Defines the expiration time that will be used for messages using the default expiration time
	 */
	@ModelNodeBinding(detypedName = "expiry-delay")
	public Long expiryDelay() {
		return this.expiryDelay;
	}

	/**
	 * Defines the expiration time that will be used for messages using the default expiration time
	 */
	@SuppressWarnings("unchecked")
	public T expiryDelay(Long value) {
		this.expiryDelay = value;
		return (T) this;
	}

	/**
	 * Defines whether a queue only uses last values or not
	 */
	@ModelNodeBinding(detypedName = "last-value-queue")
	public Boolean lastValueQueue() {
		return this.lastValueQueue;
	}

	/**
	 * Defines whether a queue only uses last values or not
	 */
	@SuppressWarnings("unchecked")
	public T lastValueQueue(Boolean value) {
		this.lastValueQueue = value;
		return (T) this;
	}

	/**
	 * Defines how many time a cancelled message can be redelivered before sending to the dead-letter-address
	 */
	@ModelNodeBinding(detypedName = "max-delivery-attempts")
	public Integer maxDeliveryAttempts() {
		return this.maxDeliveryAttempts;
	}

	/**
	 * Defines how many time a cancelled message can be redelivered before sending to the dead-letter-address
	 */
	@SuppressWarnings("unchecked")
	public T maxDeliveryAttempts(Integer value) {
		this.maxDeliveryAttempts = value;
		return (T) this;
	}

	/**
	 * Maximum value for the redelivery-delay (in ms).
	 */
	@ModelNodeBinding(detypedName = "max-redelivery-delay")
	public Long maxRedeliveryDelay() {
		return this.maxRedeliveryDelay;
	}

	/**
	 * Maximum value for the redelivery-delay (in ms).
	 */
	@SuppressWarnings("unchecked")
	public T maxRedeliveryDelay(Long value) {
		this.maxRedeliveryDelay = value;
		return (T) this;
	}

	/**
	 * The max bytes size.
	 */
	@ModelNodeBinding(detypedName = "max-size-bytes")
	public Long maxSizeBytes() {
		return this.maxSizeBytes;
	}

	/**
	 * The max bytes size.
	 */
	@SuppressWarnings("unchecked")
	public T maxSizeBytes(Long value) {
		this.maxSizeBytes = value;
		return (T) this;
	}

	/**
	 * Day limit for the message counter history.
	 */
	@ModelNodeBinding(detypedName = "message-counter-history-day-limit")
	public Integer messageCounterHistoryDayLimit() {
		return this.messageCounterHistoryDayLimit;
	}

	/**
	 * Day limit for the message counter history.
	 */
	@SuppressWarnings("unchecked")
	public T messageCounterHistoryDayLimit(Integer value) {
		this.messageCounterHistoryDayLimit = value;
		return (T) this;
	}

	/**
	 * The number of page files to keep in memory to optimize IO during paging navigation.
	 */
	@ModelNodeBinding(detypedName = "page-max-cache-size")
	public Integer pageMaxCacheSize() {
		return this.pageMaxCacheSize;
	}

	/**
	 * The number of page files to keep in memory to optimize IO during paging navigation.
	 */
	@SuppressWarnings("unchecked")
	public T pageMaxCacheSize(Integer value) {
		this.pageMaxCacheSize = value;
		return (T) this;
	}

	/**
	 * The paging size.
	 */
	@ModelNodeBinding(detypedName = "page-size-bytes")
	public Long pageSizeBytes() {
		return this.pageSizeBytes;
	}

	/**
	 * The paging size.
	 */
	@SuppressWarnings("unchecked")
	public T pageSizeBytes(Long value) {
		this.pageSizeBytes = value;
		return (T) this;
	}

	/**
	 * Defines how long to wait before attempting redelivery of a cancelled message
	 */
	@ModelNodeBinding(detypedName = "redelivery-delay")
	public Long redeliveryDelay() {
		return this.redeliveryDelay;
	}

	/**
	 * Defines how long to wait before attempting redelivery of a cancelled message
	 */
	@SuppressWarnings("unchecked")
	public T redeliveryDelay(Long value) {
		this.redeliveryDelay = value;
		return (T) this;
	}

	/**
	 * Multiplier to apply to the redelivery-delay parameter
	 */
	@ModelNodeBinding(detypedName = "redelivery-multiplier")
	public Double redeliveryMultiplier() {
		return this.redeliveryMultiplier;
	}

	/**
	 * Multiplier to apply to the redelivery-delay parameter
	 */
	@SuppressWarnings("unchecked")
	public T redeliveryMultiplier(Double value) {
		this.redeliveryMultiplier = value;
		return (T) this;
	}

	/**
	 * Defines how long to wait when the last consumer is closed on a queue before redistributing any messages
	 */
	@ModelNodeBinding(detypedName = "redistribution-delay")
	public Long redistributionDelay() {
		return this.redistributionDelay;
	}

	/**
	 * Defines how long to wait when the last consumer is closed on a queue before redistributing any messages
	 */
	@SuppressWarnings("unchecked")
	public T redistributionDelay(Long value) {
		this.redistributionDelay = value;
		return (T) this;
	}

	/**
	 * If this parameter is set to true for that address, if the message is not routed to any queues it will instead be sent to the dead letter address (DLA) for that address, if it exists.
	 */
	@ModelNodeBinding(detypedName = "send-to-dla-on-no-route")
	public Boolean sendToDlaOnNoRoute() {
		return this.sendToDlaOnNoRoute;
	}

	/**
	 * If this parameter is set to true for that address, if the message is not routed to any queues it will instead be sent to the dead letter address (DLA) for that address, if it exists.
	 */
	@SuppressWarnings("unchecked")
	public T sendToDlaOnNoRoute(Boolean value) {
		this.sendToDlaOnNoRoute = value;
		return (T) this;
	}

	/**
	 * How often to check for slow consumers on a particular queue.
	 */
	@ModelNodeBinding(detypedName = "slow-consumer-check-period")
	public Long slowConsumerCheckPeriod() {
		return this.slowConsumerCheckPeriod;
	}

	/**
	 * How often to check for slow consumers on a particular queue.
	 */
	@SuppressWarnings("unchecked")
	public T slowConsumerCheckPeriod(Long value) {
		this.slowConsumerCheckPeriod = value;
		return (T) this;
	}

	/**
	 * Determine what happens when a slow consumer is identified.
	 */
	@ModelNodeBinding(detypedName = "slow-consumer-policy")
	public String slowConsumerPolicy() {
		return this.slowConsumerPolicy;
	}

	/**
	 * Determine what happens when a slow consumer is identified.
	 */
	@SuppressWarnings("unchecked")
	public T slowConsumerPolicy(String value) {
		this.slowConsumerPolicy = value;
		return (T) this;
	}

	/**
	 * The minimum rate of message consumption allowed before a consumer is considered slow.
	 */
	@ModelNodeBinding(detypedName = "slow-consumer-threshold")
	public Long slowConsumerThreshold() {
		return this.slowConsumerThreshold;
	}

	/**
	 * The minimum rate of message consumption allowed before a consumer is considered slow.
	 */
	@SuppressWarnings("unchecked")
	public T slowConsumerThreshold(Long value) {
		this.slowConsumerThreshold = value;
		return (T) this;
	}
}