package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A messaging resource that allows you to transparently divert messages routed to one address to some other address, without making any changes to any client application logic.
 */
@ResourceType("divert")
public class Divert<T extends Divert> {

	private String key;
	private String divertAddress;
	private Boolean exclusive;
	private String filter;
	private String forwardingAddress;
	private String routingName;
	private String transformerClassName;

	public Divert(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Address to divert from
	 */
	@ModelNodeBinding(detypedName = "divert-address")
	public String divertAddress() {
		return this.divertAddress;
	}

	/**
	 * Address to divert from
	 */
	@SuppressWarnings("unchecked")
	public T divertAddress(String value) {
		this.divertAddress = value;
		return (T) this;
	}

	/**
	 * Whether the divert is exclusive, meaning that the message is diverted to the new address, and does not go to the old address at all.
	 */
	@ModelNodeBinding(detypedName = "exclusive")
	public Boolean exclusive() {
		return this.exclusive;
	}

	/**
	 * Whether the divert is exclusive, meaning that the message is diverted to the new address, and does not go to the old address at all.
	 */
	@SuppressWarnings("unchecked")
	public T exclusive(Boolean value) {
		this.exclusive = value;
		return (T) this;
	}

	/**
	 * An optional filter string. If specified then only messages which match the filter expression specified will be diverted. The filter string follows the ActiveMQ filter expression syntax described in the ActiveMQ documentation.
	 */
	@ModelNodeBinding(detypedName = "filter")
	public String filter() {
		return this.filter;
	}

	/**
	 * An optional filter string. If specified then only messages which match the filter expression specified will be diverted. The filter string follows the ActiveMQ filter expression syntax described in the ActiveMQ documentation.
	 */
	@SuppressWarnings("unchecked")
	public T filter(String value) {
		this.filter = value;
		return (T) this;
	}

	/**
	 * Address to divert to
	 */
	@ModelNodeBinding(detypedName = "forwarding-address")
	public String forwardingAddress() {
		return this.forwardingAddress;
	}

	/**
	 * Address to divert to
	 */
	@SuppressWarnings("unchecked")
	public T forwardingAddress(String value) {
		this.forwardingAddress = value;
		return (T) this;
	}

	/**
	 * Routing name of the divert
	 */
	@ModelNodeBinding(detypedName = "routing-name")
	public String routingName() {
		return this.routingName;
	}

	/**
	 * Routing name of the divert
	 */
	@SuppressWarnings("unchecked")
	public T routingName(String value) {
		this.routingName = value;
		return (T) this;
	}

	/**
	 * The name of a class used to transform the message's body or properties before it is diverted.
	 */
	@ModelNodeBinding(detypedName = "transformer-class-name")
	public String transformerClassName() {
		return this.transformerClassName;
	}

	/**
	 * The name of a class used to transform the message's body or properties before it is diverted.
	 */
	@SuppressWarnings("unchecked")
	public T transformerClassName(String value) {
		this.transformerClassName = value;
		return (T) this;
	}
}