package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Makes decisions about which node in a cluster should handle a message with a group id assigned.
 */
@ResourceType("grouping-handler")
public class GroupingHandler<T extends GroupingHandler> {

	private String key;
	private Long groupTimeout;
	private String groupingHandlerAddress;
	private Long reaperPeriod;
	private Long timeout;
	private String type;

	public GroupingHandler(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * How long a group binding will be used, -1 means for ever. Bindings are removed after this wait elapses (only valid for LOCAL handlers).
	 */
	@ModelNodeBinding(detypedName = "group-timeout")
	public Long groupTimeout() {
		return this.groupTimeout;
	}

	/**
	 * How long a group binding will be used, -1 means for ever. Bindings are removed after this wait elapses (only valid for LOCAL handlers).
	 */
	@SuppressWarnings("unchecked")
	public T groupTimeout(Long value) {
		this.groupTimeout = value;
		return (T) this;
	}

	/**
	 * A reference to a cluster connection and the address it uses.
	 */
	@ModelNodeBinding(detypedName = "grouping-handler-address")
	public String groupingHandlerAddress() {
		return this.groupingHandlerAddress;
	}

	/**
	 * A reference to a cluster connection and the address it uses.
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandlerAddress(String value) {
		this.groupingHandlerAddress = value;
		return (T) this;
	}

	/**
	 * How often the reaper will be run to check for timed out group bindings (only valid for LOCAL handlers).
	 */
	@ModelNodeBinding(detypedName = "reaper-period")
	public Long reaperPeriod() {
		return this.reaperPeriod;
	}

	/**
	 * How often the reaper will be run to check for timed out group bindings (only valid for LOCAL handlers).
	 */
	@SuppressWarnings("unchecked")
	public T reaperPeriod(Long value) {
		this.reaperPeriod = value;
		return (T) this;
	}

	/**
	 * How long to wait for a handling decision to be made; an exception will be thrown during the send if this timeout is reached, ensuring that strict ordering is kept.
	 */
	@ModelNodeBinding(detypedName = "timeout")
	public Long timeout() {
		return this.timeout;
	}

	/**
	 * How long to wait for a handling decision to be made; an exception will be thrown during the send if this timeout is reached, ensuring that strict ordering is kept.
	 */
	@SuppressWarnings("unchecked")
	public T timeout(Long value) {
		this.timeout = value;
		return (T) this;
	}

	/**
	 * Whether the handler is the single "Local" handler for the cluster, which makes handling decisions, or a "Remote" handler which converses with the local handler.
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * Whether the handler is the single "Local" handler for the cluster, which makes handling decisions, or a "Remote" handler which converses with the local handler.
	 */
	@SuppressWarnings("unchecked")
	public T type(String value) {
		this.type = value;
		return (T) this;
	}
}