package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Used by an in-VM client to define how it connects to a server.
 */
@ResourceType("in-vm-connector")
public class InVMConnector<T extends InVMConnector> {

	private String key;
	private Map params;
	private Integer serverId;

	public InVMConnector(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to configure it.
	 */
	@SuppressWarnings("unchecked")
	public T params(Map value) {
		this.params = value;
		return (T) this;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to configure it.
	 */
	public T param(String key, Object value) {
		if (this.params == null) {
			this.params = new java.util.HashMap<>();
		}
		this.params.put(key, value);
		return (T) this;
	}

	/**
	 * The server id.
	 */
	@ModelNodeBinding(detypedName = "server-id")
	public Integer serverId() {
		return this.serverId;
	}

	/**
	 * The server id.
	 */
	@SuppressWarnings("unchecked")
	public T serverId(Integer value) {
		this.serverId = value;
		return (T) this;
	}
}