package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * Defines a JMS queue.
 */
@ResourceType("jms-queue")
public class JMSQueue<T extends JMSQueue> {

	private String key;
	private Integer consumerCount;
	private String deadLetterAddress;
	private Integer deliveringCount;
	private Boolean durable;
	private List<String> entries;
	private String expiryAddress;
	private List<String> legacyEntries;
	private Long messageCount;
	private Long messagesAdded;
	private Boolean paused;
	private String queueAddress;
	private Long scheduledCount;
	private String selector;
	private Boolean temporary;

	public JMSQueue(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@ModelNodeBinding(detypedName = "consumer-count")
	public Integer consumerCount() {
		return this.consumerCount;
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@SuppressWarnings("unchecked")
	public T consumerCount(Integer value) {
		this.consumerCount = value;
		return (T) this;
	}

	/**
	 * The address to send dead messages to.
	 */
	@ModelNodeBinding(detypedName = "dead-letter-address")
	public String deadLetterAddress() {
		return this.deadLetterAddress;
	}

	/**
	 * The address to send dead messages to.
	 */
	@SuppressWarnings("unchecked")
	public T deadLetterAddress(String value) {
		this.deadLetterAddress = value;
		return (T) this;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@ModelNodeBinding(detypedName = "delivering-count")
	public Integer deliveringCount() {
		return this.deliveringCount;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@SuppressWarnings("unchecked")
	public T deliveringCount(Integer value) {
		this.deliveringCount = value;
		return (T) this;
	}

	/**
	 * Whether the queue is durable or not.
	 */
	@ModelNodeBinding(detypedName = "durable")
	public Boolean durable() {
		return this.durable;
	}

	/**
	 * Whether the queue is durable or not.
	 */
	@SuppressWarnings("unchecked")
	public T durable(Boolean value) {
		this.durable = value;
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(List<String> value) {
		this.entries = value;
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	public T entry(String value) {
		if (this.entries == null) {
			this.entries = new java.util.ArrayList<>();
		}
		this.entries.add(value);
		return (T) this;
	}

	/**
	 * The address to send expired messages to.
	 */
	@ModelNodeBinding(detypedName = "expiry-address")
	public String expiryAddress() {
		return this.expiryAddress;
	}

	/**
	 * The address to send expired messages to.
	 */
	@SuppressWarnings("unchecked")
	public T expiryAddress(String value) {
		this.expiryAddress = value;
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@ModelNodeBinding(detypedName = "legacy-entries")
	public List<String> legacyEntries() {
		return this.legacyEntries;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T legacyEntries(List<String> value) {
		this.legacyEntries = value;
		return (T) this;
	}

	/**
	 * The jndi names the queue will be bound to.
	 */
	public T legacyEntry(String value) {
		if (this.legacyEntries == null) {
			this.legacyEntries = new java.util.ArrayList<>();
		}
		this.legacyEntries.add(value);
		return (T) this;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@ModelNodeBinding(detypedName = "message-count")
	public Long messageCount() {
		return this.messageCount;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@SuppressWarnings("unchecked")
	public T messageCount(Long value) {
		this.messageCount = value;
		return (T) this;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@ModelNodeBinding(detypedName = "messages-added")
	public Long messagesAdded() {
		return this.messagesAdded;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@SuppressWarnings("unchecked")
	public T messagesAdded(Long value) {
		this.messagesAdded = value;
		return (T) this;
	}

	/**
	 * Whether the queue is paused.
	 */
	@ModelNodeBinding(detypedName = "paused")
	public Boolean paused() {
		return this.paused;
	}

	/**
	 * Whether the queue is paused.
	 */
	@SuppressWarnings("unchecked")
	public T paused(Boolean value) {
		this.paused = value;
		return (T) this;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@ModelNodeBinding(detypedName = "queue-address")
	public String queueAddress() {
		return this.queueAddress;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@SuppressWarnings("unchecked")
	public T queueAddress(String value) {
		this.queueAddress = value;
		return (T) this;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@ModelNodeBinding(detypedName = "scheduled-count")
	public Long scheduledCount() {
		return this.scheduledCount;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@SuppressWarnings("unchecked")
	public T scheduledCount(Long value) {
		this.scheduledCount = value;
		return (T) this;
	}

	/**
	 * The queue selector.
	 */
	@ModelNodeBinding(detypedName = "selector")
	public String selector() {
		return this.selector;
	}

	/**
	 * The queue selector.
	 */
	@SuppressWarnings("unchecked")
	public T selector(String value) {
		this.selector = value;
		return (T) this;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@ModelNodeBinding(detypedName = "temporary")
	public Boolean temporary() {
		return this.temporary;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@SuppressWarnings("unchecked")
	public T temporary(Boolean value) {
		this.temporary = value;
		return (T) this;
	}
}