package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Defines a way in which remote connections can be made to the ActiveMQ server.
 */
@ResourceType("remote-acceptor")
public class RemoteAcceptor<T extends RemoteAcceptor> {

	private String key;
	private Map params;
	private String socketBinding;
	private Boolean started;

	public RemoteAcceptor(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to configure it.
	 */
	@SuppressWarnings("unchecked")
	public T params(Map value) {
		this.params = value;
		return (T) this;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to configure it.
	 */
	public T param(String key, Object value) {
		if (this.params == null) {
			this.params = new java.util.HashMap<>();
		}
		this.params.put(key, value);
		return (T) this;
	}

	/**
	 * The socket binding that the acceptor will use to accept connections.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The socket binding that the acceptor will use to accept connections.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(String value) {
		this.socketBinding = value;
		return (T) this;
	}

	/**
	 * Whether this acceptor is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether this acceptor is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(Boolean value) {
		this.started = value;
		return (T) this;
	}
}