package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
/**
 * Remoting outbound connection.
 */
@ResourceType("outbound-connection")
public class OutboundConnection<T extends OutboundConnection> {

	private String key;
	private String uri;
	private OutboundConnectionResources subresources = new OutboundConnectionResources();

	public OutboundConnection(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The connection URI for the outbound connection.
	 */
	@ModelNodeBinding(detypedName = "uri")
	public String uri() {
		return this.uri;
	}

	/**
	 * The connection URI for the outbound connection.
	 */
	@SuppressWarnings("unchecked")
	public T uri(String value) {
		this.uri = value;
		return (T) this;
	}

	public OutboundConnectionResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.remoting.Property objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.remoting.Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T propertys(List<org.wildfly.swarm.config.remoting.Property> value) {
		this.subresources.propertys = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.remoting.Property object to the list of subresources
	 * @param value The org.wildfly.swarm.config.remoting.Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.propertys.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.Property object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.Property resource
	 * @param config The org.wildfly.swarm.config.remoting.PropertyConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(String childKey, PropertyConfigurator config) {
		org.wildfly.swarm.config.remoting.Property child = new org.wildfly.swarm.config.remoting.Property(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		property(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.Property object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.Property resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(String childKey) {
		property(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for OutboundConnection
	 */
	public class OutboundConnectionResources {
		/**
		 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
		 */
		private List<org.wildfly.swarm.config.remoting.Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.remoting.Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}
}