package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
/**
 * Remoting outbound connection with an implicit remote:// URI scheme.
 */
@ResourceType("remote-outbound-connection")
public class RemoteOutboundConnection<T extends RemoteOutboundConnection> {

	private String key;
	private String outboundSocketBindingRef;
	private String protocol;
	private String securityRealm;
	private String username;
	private RemoteOutboundConnectionResources subresources = new RemoteOutboundConnectionResources();

	public RemoteOutboundConnection(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Name of the outbound-socket-binding which will be used to determine the destination address and port for the connection.
	 */
	@ModelNodeBinding(detypedName = "outbound-socket-binding-ref")
	public String outboundSocketBindingRef() {
		return this.outboundSocketBindingRef;
	}

	/**
	 * Name of the outbound-socket-binding which will be used to determine the destination address and port for the connection.
	 */
	@SuppressWarnings("unchecked")
	public T outboundSocketBindingRef(String value) {
		this.outboundSocketBindingRef = value;
		return (T) this;
	}

	/**
	 * The protocol to use for the remote connection. Defaults to http-remoting.
	 */
	@ModelNodeBinding(detypedName = "protocol")
	public String protocol() {
		return this.protocol;
	}

	/**
	 * The protocol to use for the remote connection. Defaults to http-remoting.
	 */
	@SuppressWarnings("unchecked")
	public T protocol(String value) {
		this.protocol = value;
		return (T) this;
	}

	/**
	 * Reference to the security realm to use to obtain the password and SSL configuration.
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * Reference to the security realm to use to obtain the password and SSL configuration.
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(String value) {
		this.securityRealm = value;
		return (T) this;
	}

	/**
	 * The user name to use when authenticating against the remote server.
	 */
	@ModelNodeBinding(detypedName = "username")
	public String username() {
		return this.username;
	}

	/**
	 * The user name to use when authenticating against the remote server.
	 */
	@SuppressWarnings("unchecked")
	public T username(String value) {
		this.username = value;
		return (T) this;
	}

	public RemoteOutboundConnectionResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.remoting.Property objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.remoting.Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T propertys(List<org.wildfly.swarm.config.remoting.Property> value) {
		this.subresources.propertys = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.remoting.Property object to the list of subresources
	 * @param value The org.wildfly.swarm.config.remoting.Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.propertys.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.Property object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.Property resource
	 * @param config The org.wildfly.swarm.config.remoting.PropertyConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(String childKey, PropertyConfigurator config) {
		org.wildfly.swarm.config.remoting.Property child = new org.wildfly.swarm.config.remoting.Property(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		property(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.remoting.Property object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.remoting.Property resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(String childKey) {
		property(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for RemoteOutboundConnection
	 */
	public class RemoteOutboundConnectionResources {
		/**
		 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
		 */
		private List<org.wildfly.swarm.config.remoting.Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.remoting.Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}
}