package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Security Vault for attributes.
 */
@ResourceType("vault")
@Implicit
public class ClassicVault<T extends ClassicVault> {

	private String key;
	private String code;
	private Map vaultOptions;

	public ClassicVault() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Fully Qualified Name of the Security Vault Implementation.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Fully Qualified Name of the Security Vault Implementation.
	 */
	@SuppressWarnings("unchecked")
	public T code(String value) {
		this.code = value;
		return (T) this;
	}

	/**
	 * Security Vault options.
	 */
	@ModelNodeBinding(detypedName = "vault-options")
	public Map vaultOptions() {
		return this.vaultOptions;
	}

	/**
	 * Security Vault options.
	 */
	@SuppressWarnings("unchecked")
	public T vaultOptions(Map value) {
		this.vaultOptions = value;
		return (T) this;
	}

	/**
	 * Security Vault options.
	 */
	public T vaultOption(String key, Object value) {
		if (this.vaultOptions == null) {
			this.vaultOptions = new java.util.HashMap<>();
		}
		this.vaultOptions.put(key, value);
		return (T) this;
	}
}