package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.audit.ProviderModule;
import org.wildfly.swarm.config.security.security_domain.audit.ProviderModuleConfigurator;
/**
 * Auditing configuration. Configures a list of provider modules to be used.
 */
@ResourceType("audit")
@Implicit
public class ClassicAudit<T extends ClassicAudit> {

	private String key;
	private ClassicAuditResources subresources = new ClassicAuditResources();

	public ClassicAudit() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public ClassicAuditResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.audit.ProviderModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.audit.ProviderModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T providerModules(
			List<org.wildfly.swarm.config.security.security_domain.audit.ProviderModule> value) {
		this.subresources.providerModules = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.audit.ProviderModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.audit.ProviderModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerModule(ProviderModule value) {
		this.subresources.providerModules.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.audit.ProviderModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.audit.ProviderModule resource
	 * @param config The org.wildfly.swarm.config.security.security_domain.audit.ProviderModuleConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerModule(String childKey, ProviderModuleConfigurator config) {
		org.wildfly.swarm.config.security.security_domain.audit.ProviderModule child = new org.wildfly.swarm.config.security.security_domain.audit.ProviderModule(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		providerModule(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.audit.ProviderModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.audit.ProviderModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerModule(String childKey) {
		providerModule(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for ClassicAudit
	 */
	public class ClassicAuditResources {
		/**
		 * List of modules that map principal, role, and credential information
		 */
		private List<org.wildfly.swarm.config.security.security_domain.audit.ProviderModule> providerModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.audit.ProviderModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ProviderModule> providerModules() {
			return this.providerModules;
		}
	}
}