package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * JSSE configuration. Configures attributes for keystores that can be used for setting up SSL.
 */
@ResourceType("jsse")
@Implicit
public class ClassicJSSE<T extends ClassicJSSE> {

	private String key;
	private Map additionalProperties;
	private String cipherSuites;
	private String clientAlias;
	private Boolean clientAuth;
	private Map keyManager;
	private Map keystore;
	private String protocols;
	private String serverAlias;
	private String serviceAuthToken;
	private Map trustManager;
	private Map truststore;

	public ClassicJSSE() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Additional properties that may be necessary to configure JSSE.
	 */
	@ModelNodeBinding(detypedName = "additional-properties")
	public Map additionalProperties() {
		return this.additionalProperties;
	}

	/**
	 * Additional properties that may be necessary to configure JSSE.
	 */
	@SuppressWarnings("unchecked")
	public T additionalProperties(Map value) {
		this.additionalProperties = value;
		return (T) this;
	}

	/**
	 * Additional properties that may be necessary to configure JSSE.
	 */
	public T additionalProperty(String key, Object value) {
		if (this.additionalProperties == null) {
			this.additionalProperties = new java.util.HashMap<>();
		}
		this.additionalProperties.put(key, value);
		return (T) this;
	}

	/**
	 * Comma separated list of cipher suites to enable on SSLSockets.
	 */
	@ModelNodeBinding(detypedName = "cipher-suites")
	public String cipherSuites() {
		return this.cipherSuites;
	}

	/**
	 * Comma separated list of cipher suites to enable on SSLSockets.
	 */
	@SuppressWarnings("unchecked")
	public T cipherSuites(String value) {
		this.cipherSuites = value;
		return (T) this;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the client alias.
	 */
	@ModelNodeBinding(detypedName = "client-alias")
	public String clientAlias() {
		return this.clientAlias;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the client alias.
	 */
	@SuppressWarnings("unchecked")
	public T clientAlias(String value) {
		this.clientAlias = value;
		return (T) this;
	}

	/**
	 * Boolean attribute to indicate if client's certificates should also be authenticated on the server side.
	 */
	@ModelNodeBinding(detypedName = "client-auth")
	public Boolean clientAuth() {
		return this.clientAuth;
	}

	/**
	 * Boolean attribute to indicate if client's certificates should also be authenticated on the server side.
	 */
	@SuppressWarnings("unchecked")
	public T clientAuth(Boolean value) {
		this.clientAuth = value;
		return (T) this;
	}

	/**
	 * JSEE Key Manager factory
	 */
	@ModelNodeBinding(detypedName = "key-manager")
	public Map keyManager() {
		return this.keyManager;
	}

	/**
	 * JSEE Key Manager factory
	 */
	@SuppressWarnings("unchecked")
	public T keyManager(Map value) {
		this.keyManager = value;
		return (T) this;
	}

	/**
	 * JSEE Key Manager factory
	 */
	public T keyManager(String key, Object value) {
		if (this.keyManager == null) {
			this.keyManager = new java.util.HashMap<>();
		}
		this.keyManager.put(key, value);
		return (T) this;
	}

	/**
	 * Configures a JSSE key store
	 */
	@ModelNodeBinding(detypedName = "keystore")
	public Map keystore() {
		return this.keystore;
	}

	/**
	 * Configures a JSSE key store
	 */
	@SuppressWarnings("unchecked")
	public T keystore(Map value) {
		this.keystore = value;
		return (T) this;
	}

	/**
	 * Configures a JSSE key store
	 */
	public T keystore(String key, Object value) {
		if (this.keystore == null) {
			this.keystore = new java.util.HashMap<>();
		}
		this.keystore.put(key, value);
		return (T) this;
	}

	/**
	 * Comma separated list of protocols to enable on SSLSockets.
	 */
	@ModelNodeBinding(detypedName = "protocols")
	public String protocols() {
		return this.protocols;
	}

	/**
	 * Comma separated list of protocols to enable on SSLSockets.
	 */
	@SuppressWarnings("unchecked")
	public T protocols(String value) {
		this.protocols = value;
		return (T) this;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the server alias.
	 */
	@ModelNodeBinding(detypedName = "server-alias")
	public String serverAlias() {
		return this.serverAlias;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the server alias.
	 */
	@SuppressWarnings("unchecked")
	public T serverAlias(String value) {
		this.serverAlias = value;
		return (T) this;
	}

	/**
	 * Token to retrieve PrivateKeys from the KeyStore.
	 */
	@ModelNodeBinding(detypedName = "service-auth-token")
	public String serviceAuthToken() {
		return this.serviceAuthToken;
	}

	/**
	 * Token to retrieve PrivateKeys from the KeyStore.
	 */
	@SuppressWarnings("unchecked")
	public T serviceAuthToken(String value) {
		this.serviceAuthToken = value;
		return (T) this;
	}

	/**
	 * JSEE Trust Manager factory
	 */
	@ModelNodeBinding(detypedName = "trust-manager")
	public Map trustManager() {
		return this.trustManager;
	}

	/**
	 * JSEE Trust Manager factory
	 */
	@SuppressWarnings("unchecked")
	public T trustManager(Map value) {
		this.trustManager = value;
		return (T) this;
	}

	/**
	 * JSEE Trust Manager factory
	 */
	public T trustManager(String key, Object value) {
		if (this.trustManager == null) {
			this.trustManager = new java.util.HashMap<>();
		}
		this.trustManager.put(key, value);
		return (T) this;
	}

	/**
	 * Configures a JSSE trust store
	 */
	@ModelNodeBinding(detypedName = "truststore")
	public Map truststore() {
		return this.truststore;
	}

	/**
	 * Configures a JSSE trust store
	 */
	@SuppressWarnings("unchecked")
	public T truststore(Map value) {
		this.truststore = value;
		return (T) this;
	}

	/**
	 * Configures a JSSE trust store
	 */
	public T truststore(String key, Object value) {
		if (this.truststore == null) {
			this.truststore = new java.util.HashMap<>();
		}
		this.truststore.put(key, value);
		return (T) this;
	}
}