package org.wildfly.swarm.config.security.security_domain.audit;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * List of modules that map principal, role, and credential information
 */
@ResourceType("provider-module")
public class ProviderModule<T extends ProviderModule> {

	private String key;
	private String code;
	private Map moduleOptions;

	public ProviderModule(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@SuppressWarnings("unchecked")
	public T code(String value) {
		this.code = value;
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@ModelNodeBinding(detypedName = "module-options")
	public Map moduleOptions() {
		return this.moduleOptions;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public T moduleOptions(Map value) {
		this.moduleOptions = value;
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	public T moduleOption(String key, Object value) {
		if (this.moduleOptions == null) {
			this.moduleOptions = new java.util.HashMap<>();
		}
		this.moduleOptions.put(key, value);
		return (T) this;
	}
}