package org.wildfly.swarm.config.security.security_domain.authentication;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * List of authentication modules
 */
@ResourceType("login-module")
public class LoginModule<T extends LoginModule> {

	private String key;
	private String code;
	private String flag;
	private String module;
	private Map moduleOptions;

	public LoginModule(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@SuppressWarnings("unchecked")
	public T code(String value) {
		this.code = value;
		return (T) this;
	}

	/**
	 * The flag controls how the module participates in the overall procedure. Allowed values are requisite, required, sufficient or optional.
	 */
	@ModelNodeBinding(detypedName = "flag")
	public String flag() {
		return this.flag;
	}

	/**
	 * The flag controls how the module participates in the overall procedure. Allowed values are requisite, required, sufficient or optional.
	 */
	@SuppressWarnings("unchecked")
	public T flag(String value) {
		this.flag = value;
		return (T) this;
	}

	/**
	 * Name of JBoss Module where the login module is located.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Name of JBoss Module where the login module is located.
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		this.module = value;
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@ModelNodeBinding(detypedName = "module-options")
	public Map moduleOptions() {
		return this.moduleOptions;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public T moduleOptions(Map value) {
		this.moduleOptions = value;
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	public T moduleOption(String key, Object value) {
		if (this.moduleOptions == null) {
			this.moduleOptions = new java.util.HashMap<>();
		}
		this.moduleOptions.put(key, value);
		return (T) this;
	}
}