package org.wildfly.swarm.config.transactions.log_store.transactions;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The resources that did work in a transaction.
 */
@ResourceType("participants")
public class Participants<T extends Participants> {

	private String key;
	private String eisProductName;
	private String eisProductVersion;
	private String jmxName;
	private String jndiName;
	private String status;
	private String type;

	public Participants(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The JCA enterprise information system's product name.
	 */
	@ModelNodeBinding(detypedName = "eis-product-name")
	public String eisProductName() {
		return this.eisProductName;
	}

	/**
	 * The JCA enterprise information system's product name.
	 */
	@SuppressWarnings("unchecked")
	public T eisProductName(String value) {
		this.eisProductName = value;
		return (T) this;
	}

	/**
	 * The JCA enterprise information system's product version
	 */
	@ModelNodeBinding(detypedName = "eis-product-version")
	public String eisProductVersion() {
		return this.eisProductVersion;
	}

	/**
	 * The JCA enterprise information system's product version
	 */
	@SuppressWarnings("unchecked")
	public T eisProductVersion(String value) {
		this.eisProductVersion = value;
		return (T) this;
	}

	/**
	 * The JMX name of this participant.
	 */
	@ModelNodeBinding(detypedName = "jmx-name")
	public String jmxName() {
		return this.jmxName;
	}

	/**
	 * The JMX name of this participant.
	 */
	@SuppressWarnings("unchecked")
	public T jmxName(String value) {
		this.jmxName = value;
		return (T) this;
	}

	/**
	 * JNDI name of this participant.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * JNDI name of this participant.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		this.jndiName = value;
		return (T) this;
	}

	/**
	 * Reports the commitment status of this participant (can be one of Pending, Prepared, Failed, Heuristic or Readonly).
	 */
	@ModelNodeBinding(detypedName = "status")
	public String status() {
		return this.status;
	}

	/**
	 * Reports the commitment status of this participant (can be one of Pending, Prepared, Failed, Heuristic or Readonly).
	 */
	@SuppressWarnings("unchecked")
	public T status(String value) {
		this.status = value;
		return (T) this;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@SuppressWarnings("unchecked")
	public T type(String value) {
		this.type = value;
		return (T) this;
	}
}